/**
 * JQueryプラグイン：クイックソートプラグイン
 * 
 * JQuery集合に対してクイックソートを実施するためのプラグインです
 * 		JQueryクイックソートプラグインは、ユーザ定義のコンパレータ、ソートオーダー、処理後コールバック関数
 * 		を指定することによって、JQuery要素や通常の配列に対して、ソートを行うことができます
 */
(function($){
	
	/**
	 * name:クイックソート
	 * @param compareHandler function(jquery, jquery)
	 * @param sortorder boolean(true:昇順/false:降順)
	 * @param afterHandler function(array<jquery>)
	 */
	$.fn.quicksort = function(compareHandler, sortorder, afterHandler){
		console.log("sortorder:" + sortorder);
		// ====================== クイックソート関数オブジェクト：ここから =============================
		var sortData2 = function(target, comparator, sortorder){
			var paramCheck = false;
			paramCheck = paramCheck || (comparator == null);
			paramCheck = paramCheck || (comparator == undefined);
			paramCheck = paramCheck || ((typeof comparator) != 'function');
			if(paramCheck) {
				return target;
			}
			//console.log("target length:" + target.length);
			//もし配列の長さが1以下ならそのまま返す
			if(target.length <= 1) {
				return target;
			} else {
				//そうでなければ、
				//配列の最後の要素を取り出す(pivot)
				
				var pivot = target.pop();
				//console.log("pivot:" + pivot);
				var shr = [];
				var lng = [];
				
				//配列の要素をひとつずつ取り出し
				for(var index in target){

					
					
					if(comparator(target[index] , pivot)) {
						shr.push(target[index]);
					} else {
						//そうでなければ配列 l に入れる
						lng.push(target[index]);
					}
				}
				
				//console.log("shr size:" + shr.length + " lng size:" + lng.length);
				//配列 s を再帰的に関数qsortに渡す
				shr = sortData2(shr, comparator);
				//ソートされた配列 s の最後にpivotを加える
				shr.push(pivot);
				//配列 s に、配列 l を再帰的に関数qsortに渡して返す
				return shr.concat(sortData2(lng, comparator));
			}
		};
		// ====================== クイックソート関数オブジェクト：ここまで =============================
		
		// パラメータチェック
		var paramCheck = false;
		paramCheck = paramCheck || (compareHandler == null);
		paramCheck = paramCheck || (compareHandler == undefined);
		paramCheck = paramCheck || ((typeof compareHandler) != 'function');
		
		if(paramCheck) {
			console.error("parameter [compareHandler] is invalid");
			return $(this);
		}
		paramCheck = false;
		paramCheck = paramCheck || (compareHandler == null);
		paramCheck = paramCheck || (compareHandler == undefined);
		if(paramCheck) {
			console.error("parameter [sortorder] is invalid");
			return $(this);
		}
		
		// コンテキストを配列に格納
		var objectArray = [];
		//console.log("element deep copy");
		$(this).each(function(index, element){
			// 配列にディープコピー
			objectArray.push($(element).clone(true, true));
		});
		//console.log("element deep copy result[" + objectArray.length + "]");
		
		// テスト用
		//var a = [1, 2, 3, 5, 8, 10, 3, 8, 101, 22];
		
		//console.log("start quick sort");
		objectArray = sortData2(objectArray, compareHandler, sortorder);
		
		paramCheck = false;
		paramCheck = paramCheck || (afterHandler == null);
		paramCheck = paramCheck || (afterHandler == undefined);
		paramCheck = paramCheck || ((typeof afterHandler) != 'function');
		if(!paramCheck) {
			// 処理後ハンドラの起動
			
			if(sortorder) {
				afterHandler(objectArray);
			} else {
				afterHandler(objectArray.reverse());
			}
			
			
		}
		
		return $(this);
	};
	
	/**
	 * name:クイックソート
	 * @param targetArray array
	 * @param compareHandler function(jquery, jquery)
	 * @param sortorder boolean(true:昇順/false:降順)
	 * @param afterHandler function(array<jquery>)
	 */
	$.quicksort ={
		"sort":	function(targetArray, compareHandler, sortorder, afterHandler){
			// ====================== クイックソート関数オブジェクト：ここから =============================
			var sortData2 = function(target, comparator, sortorder){
				var paramCheck = false;
				paramCheck = paramCheck || (comparator == null);
				paramCheck = paramCheck || (comparator == undefined);
				paramCheck = paramCheck || ((typeof comparator) != 'function');
				if(paramCheck) {
					return target;
				}
				//console.log("target length:" + target.length);
				//もし配列の長さが1以下ならそのまま返す
				if(target.length <= 1) {
					return target;
				} else {
					//そうでなければ、
					//配列の最後の要素を取り出す(pivot)
					
					var pivot = target.pop();
					//console.log("pivot:" + pivot);
					var shr = [];
					var lng = [];
					
					//配列の要素をひとつずつ取り出し
					for(var index in target){
						//もしpivotよりも小さければ配列 s に入れる
						if(comparator(target[index] , pivot)) {
							shr.push(target[index]);
						} else {
							//そうでなければ配列 l に入れる
							lng.push(target[index]);
						}
					}
					
					//console.log("shr size:" + shr.length + " lng size:" + lng.length);
					//配列 s を再帰的に関数qsortに渡す
					shr = sortData2(shr, comparator);
					//ソートされた配列 s の最後にpivotを加える
					shr.push(pivot);
					
					
					var result = shr.concat(sortData2(lng, comparator));
					
//					if(!sortorder) {
//						result = result.reverse();
//					}
					
					//配列 s に、配列 l を再帰的に関数qsortに渡して返す
					return shr.concat(sortData2(lng, comparator));
				}
			};
			// ====================== クイックソート関数オブジェクト：ここまで =============================
			
			
			// パラメータチェック
			var paramCheck = false;
			paramCheck = paramCheck || (compareHandler == null);
			paramCheck = paramCheck || (compareHandler == undefined);
			paramCheck = paramCheck || ((typeof compareHandler) != 'function');
			
			if(paramCheck) {
				console.error("parameter [compareHandler] is invalid");
				return $(this);
			}
			paramCheck = false;
			paramCheck = paramCheck || (compareHandler == null);
			paramCheck = paramCheck || (compareHandler == undefined);
			if(paramCheck) {
				console.error("parameter [sortorder] is invalid");
				return $(this);
			}
			
			// クイックソート実行
			targetArray = sortData2(targetArray, compareHandler, sortorder);
			
			paramCheck = false;
			paramCheck = paramCheck || (afterHandler == null);
			paramCheck = paramCheck || (afterHandler == undefined);
			paramCheck = paramCheck || ((typeof afterHandler) != 'function');
			if(!paramCheck) {
				// 処理後ハンドラの起動
				afterHandler(targetArray);
			}
			
			if(!sortorder) {
				targetArray = targetArray.reverse();
			}
			
			return targetArray;
		},
		"stringComparator":	function(strA, strB){
			return strA < strB;
		}
	};

})(jQuery);