/**
 * 
 */
(function($){
	$.fn.painter = function(options, func){
		var $$ = $(this);
		if(func == null || func == undefined || (typeof func) !== 'function') {
			return $$;
		}
		var tagName = $$[0].tagName;
		if(tagName !== 'CANVAS') {
			return $$;
		}
		
//		if(options == null || options == undefined || options.target == null || options.target == undefined) {
//			console.log('options is invalid')
//			return $$;
//		}
		
		var canvas = $$[0];
		var ctx = canvas.getContext('2d');
		
		var isDraw = false;
		var x = 0;
		var y = 0;
		
		canvas.addEventListener('mousedown', function(e) {
			if($.browser.is("msie")) {
				x = e.offsetX;
				y = e.offsetY;
				ctx.moveTo(e.offsetX, e.offsetY);
			} else {
				x = e.layerX;
				y = e.layerY;
				ctx.moveTo(e.layerX, e.layerY);
			}

			isDraw = true;
		}, 'false');

		canvas.addEventListener('mousemove', function(e) {
			if($.browser.is("msie")) {
				$("#mousex").val(e.offsetX).change();
				$("#mousey").val(e.offsetY).change();
			} else {
				//console.log(e);
				$("#mousex").val(e.layerX).change();
				$("#mousey").val(e.layerY).change();
			}
			if (isDraw) {
				$(this).css("cursor", "crosshair");
				
				//console.log(e);
				setTimeout(function() {
					var paramObject = null;
					
					if($.browser.is("msie")) {
						paramObject = {
								fromX : x,
								fromY : y,
								toX : e.offsetX,
								toY : e.offsetY
							};
					} else {
						paramObject = {
								fromX : x,
								fromY : y,
								toX : e.layerX,
								toY : e.layerY
							};
					}

					//console.log(paramObject);
					if($.browser.is("msie")) {
						x = e.offsetX;
						y = e.offsetY;
					} else {
						x = e.layerX;
						y = e.layerY;
					}

					ctx.lineTo(x, y);
					ctx.stroke();
					
					try {
						func(paramObject);
					} catch(e) {
						console.log(canvas);
						console.error(e);
					}
					
				}, 10);
				$(this).css("cursor", "pointer");
			} else {
				if($.browser.is("msie")) {
					x = e.offsetX;
					y = e.offsetY;
				} else {
					x = e.layerX;
					y = e.layerY;
				}
			}
		}, 'false');

		canvas.addEventListener('mouseup', function(e) {
			isDraw = false;
		}, 'false');
		
		canvas.addEventListener('mouseout', function(e) {
			isDraw = false;
		}, 'false');
		ctx.moveTo(0, 0);
		
		
		return $$;
	};
})(jQuery);