package net.morilib.db.info;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.morilib.db.jdbc.BeanListResultSet;
import net.morilib.db.misc.LikeWildcard;
import net.morilib.db.schema.SqlSchema;

public class TablesInfo {

	static final String[] INFO = new String[] {
		"tableCat",
		"tableSchem",
		"tableName",
		"tableType",
		"remarks",
		"typeCat",
		"typeSchem",
		"typeName",
		"selfReferencingColName",
		"refGeneration",
	};

	private String tableCat;
	private String tableSchem;
	private String tableName;
	private String tableType;
	private String remarks;
	private String typeCat;
	private String typeSchem;
	private String typeName;
	private String selfReferencingColName;
	private String refGeneration;

	public static BeanListResultSet get(SqlSchema sql, String tn,
			String... tp) throws IOException, SQLException {
		List<TablesInfo> l = new ArrayList<TablesInfo>();
		List<String> y = Arrays.asList(tp);
		LikeWildcard tw;
		TablesInfo f;

		tw = LikeWildcard.compile(tn != null ? tn : "%");
		if(y.contains("TABLE")) {
			for(String s : sql.getTableNames()) {
				if(!tw.matches(s))  continue;
				f = new TablesInfo();
				f.tableName = s;
				f.tableType = "TABLE";
				l.add(f);
			}
		}
		return new BeanListResultSet(TablesInfo.class,
				Arrays.asList(INFO), l);
	}

	public String getRefGeneration() {
		return refGeneration;
	}

	public void setRefGeneration(String refGeneration) {
		this.refGeneration = refGeneration;
	}

	public String getTableCat() {
		return tableCat;
	}

	public void setTableCat(String tableCat) {
		this.tableCat = tableCat;
	}

	public String getTableSchem() {
		return tableSchem;
	}

	public void setTableSchem(String tableSchem) {
		this.tableSchem = tableSchem;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public String getTableType() {
		return tableType;
	}

	public void setTableType(String tableType) {
		this.tableType = tableType;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	public String getTypeCat() {
		return typeCat;
	}

	public void setTypeCat(String typeCat) {
		this.typeCat = typeCat;
	}

	public String getTypeSchem() {
		return typeSchem;
	}

	public void setTypeSchem(String typeSchem) {
		this.typeSchem = typeSchem;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public String getSelfReferencingColName() {
		return selfReferencingColName;
	}

	public void setSelfReferencingColName(String selfReferencingColName) {
		this.selfReferencingColName = selfReferencingColName;
	}

}
