package net.morilib.db.fichier;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class MemoryFichier implements Fichier {

	private static final int BUFSIZE = 16384;

	private String name;
	private char[] buf;
	private int length = -1;

	public MemoryFichier(String n) {
		name = n;
		buf = new char[BUFSIZE];
	}

	@Override
	public boolean isFile() {
		return length >= 0;
	}

	@Override
	public boolean createNewFile() throws IOException {
		length = 0;
		return true;
	}

	@Override
	public Reader openReader() throws IOException {
		final int[] c = new int[1];

		if(length < 0)  throw new IOException();
		c[0] = 0;
		return new Reader() {

			@Override
			public int read(char[] cbuf, int off,
					int len) throws IOException {
				int l;

				if(c[0] < 0) {
					throw new IOException();
				} else if(c[0] >= length) {
					return -1;
				} else {
					l = c[0] + len >= length ? length - c[0] : len;
					System.arraycopy(buf, c[0], cbuf, off, l);
					c[0] += l;
					return l;
				}
			}

			@Override
			public void close() throws IOException {
				if(c[0] < 0)  throw new IOException();
				c[0] = -2;
			}

		};
	}

	@Override
	public Writer openWriter() throws IOException {
		final boolean[] c = new boolean[1];

		length = 0;
		c[0] = false;
		return new Writer() {

			@Override
			public void write(char[] cbuf, int off,
					int len) throws IOException {
				if(c[0])  throw new IOException();
				if(length + len >= BUFSIZE) {
					throw new IOException();
				}
				System.arraycopy(cbuf, off, buf, length, len);
				length += len;
			}

			@Override
			public void close() throws IOException {
				if(c[0])  throw new IOException();
				c[0] = true;
			}

			@Override
			public void flush() throws IOException {
				// do nothing
			}

		};
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public boolean delete() throws IOException {
		length = -1;
		return true;
	}

	@Override
	public Fichier[] listFichiers() {
		return null;
	}

	@Override
	public boolean renameTo(Fichier f) throws IOException {
		return false;
	}

}
