/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.misc;

import java.io.IOException;
import java.sql.SQLException;

import net.morilib.parser.html.HTMLParser;
import junit.framework.TestCase;

public class HTMLTableHandlerTest extends TestCase {

	public void testTable001() {
		HTMLTableHandler h = new HTMLTableHandler("tbl");

		try {
			HTMLParser.parse(h,
					"<table id=dummy>"
					+ "  <tr>"
					+ "    <td>aaaaa</td>"
					+ "  </tr>"
					+ "    <td>11</td>"
					+ "  </tr>"
					+ "</table>"
					+ "<table id=tbl>"
					+ "  <tr>"
					+ "    <td>aaaaa</td>"
					+ "    <td>bbbbb</td>"
					+ "    <td>ccccc</td>"
					+ "    <td>ddddd</td>"
					+ "  </tr>"
					+ "  <tr>"
					+ "    <td>11</td>"
					+ "    <td>12</td>"
					+ "    <td>13</td>"
					+ "    <td>14</td>"
					+ "  </tr>"
					+ "  <tr>"
					+ "    <td>21</td>"
					+ "    <td>22</td>"
					+ "    <td>23</td>"
					+ "  </tr>"
					+ "</table>");
		} catch(SQLException e) {
			throw new RuntimeException(e);
		} catch(IOException e) {
			throw new RuntimeException(e);
		} catch(HTMLTermException e) {
			// do nothing
		}

		assertEquals(3, h.getValues().size());
		assertEquals(4, h.getValues().get(0).size());
		assertEquals("aaaaa", h.getValues().get(0).get(0));
		assertEquals("bbbbb", h.getValues().get(0).get(1));
		assertEquals("ccccc", h.getValues().get(0).get(2));
		assertEquals("ddddd", h.getValues().get(0).get(3));
		assertEquals(4, h.getValues().get(1).size());
		assertEquals("11", h.getValues().get(1).get(0));
		assertEquals("12", h.getValues().get(1).get(1));
		assertEquals("13", h.getValues().get(1).get(2));
		assertEquals("14", h.getValues().get(1).get(3));
		assertEquals(3, h.getValues().get(2).size());
		assertEquals("21", h.getValues().get(2).get(0));
		assertEquals("22", h.getValues().get(2).get(1));
		assertEquals("23", h.getValues().get(2).get(2));
	}

	public void testTable002() {
		HTMLTableHandler h = new HTMLTableHandler("tbl");

		try {
			HTMLParser.parse(h,
					"<table id=tbl>"
					+ "  <tr>"
					+ "    <th>aaaaa</th>"
					+ "    <th>bbbbb</th>"
					+ "    <th>ccccc</th>"
					+ "    <th>ddddd</th>"
					+ "  </tr>"
					+ "  <tr>"
					+ "    <td>11"
					+ "    <td>12"
					+ "    <td>13"
					+ "    <td>14"
					+ "  <tr>"
					+ "    <td>21</td>"
					+ "    <td>22</td>"
					+ "    <td>23</td>"
					+ "  </tr>"
					+ "</table>");
		} catch(SQLException e) {
			throw new RuntimeException(e);
		} catch(IOException e) {
			throw new RuntimeException(e);
		} catch(HTMLTermException e) {
			// do nothing
		}

		assertEquals(3, h.getValues().size());
		assertEquals(4, h.getValues().get(0).size());
		assertEquals("aaaaa", h.getValues().get(0).get(0));
		assertEquals("bbbbb", h.getValues().get(0).get(1));
		assertEquals("ccccc", h.getValues().get(0).get(2));
		assertEquals("ddddd", h.getValues().get(0).get(3));
		assertEquals(4, h.getValues().get(1).size());
		assertEquals("11", h.getValues().get(1).get(0));
		assertEquals("12", h.getValues().get(1).get(1));
		assertEquals("13", h.getValues().get(1).get(2));
		assertEquals("14", h.getValues().get(1).get(3));
		assertEquals(3, h.getValues().get(2).size());
		assertEquals("21", h.getValues().get(2).get(0));
		assertEquals("22", h.getValues().get(2).get(1));
		assertEquals("23", h.getValues().get(2).get(2));
	}

	public void testTable003() {
		HTMLTableHandler h = new HTMLTableHandler("table2");

		try {
			HTMLParser.parse(h,
					"<table id=dummy>"
					+ "  <tr>"
					+ "    <td>aaaaa</td>"
					+ "  </tr>"
					+ "    <td>11</td>"
					+ "  </tr>"
					+ "</table>"
					+ "<table>"
					+ "  <tr>"
					+ "    <th>aaaaa</th>"
					+ "    <th>bbbbb</th>"
					+ "    <th>ccccc</th>"
					+ "    <th>ddddd</th>"
					+ "  </tr>"
					+ "  <tr>"
					+ "    <td>11"
					+ "    <td>12"
					+ "    <td>13"
					+ "    <td>14"
					+ "  <tr>"
					+ "    <td>21</td>"
					+ "    <td>22</td>"
					+ "    <td>23</td>"
					+ "  </tr>"
					+ "</table>");
		} catch(SQLException e) {
			throw new RuntimeException(e);
		} catch(IOException e) {
			throw new RuntimeException(e);
		} catch(HTMLTermException e) {
			// do nothing
		}

		assertEquals(3, h.getValues().size());
		assertEquals(4, h.getValues().get(0).size());
		assertEquals("aaaaa", h.getValues().get(0).get(0));
		assertEquals("bbbbb", h.getValues().get(0).get(1));
		assertEquals("ccccc", h.getValues().get(0).get(2));
		assertEquals("ddddd", h.getValues().get(0).get(3));
		assertEquals(4, h.getValues().get(1).size());
		assertEquals("11", h.getValues().get(1).get(0));
		assertEquals("12", h.getValues().get(1).get(1));
		assertEquals("13", h.getValues().get(1).get(2));
		assertEquals("14", h.getValues().get(1).get(3));
		assertEquals(3, h.getValues().get(2).size());
		assertEquals("21", h.getValues().get(2).get(0));
		assertEquals("22", h.getValues().get(2).get(1));
		assertEquals("23", h.getValues().get(2).get(2));
	}

}
