/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sql.RePlus;

public class ZRelagent extends JFrame {

	private static final String HELP =
			"morilib Relations\n" +
			"Ver. " + RePlus.VERSION + "\n" +
			"Copyright 2013 Yuichiro Moriguchi\n" +
			"This program is under Apache License 2.0";

	private JTabbedPane tabs;
	private JToolBar tbar;
	private JTextField tf1;

	public ZRelagent() {
		Container pane = getContentPane();
		final Action a1 = new AbstractAction("close") {

			@Override
			public void actionPerformed(ActionEvent e) {
				tabs.remove(tabs.getSelectedIndex());
			}

		};
		JPopupMenu p1 = new JPopupMenu() {

			public void show(Component c, int x, int y) {
				a1.setEnabled(tabs.indexAtLocation(x, y) >= 0);
				super.show(c, x, y);
			}

		};
		JMenuItem mim;
		JMenuBar bar;
		JMenu mnu;

		//
		setSize(800, 600);
		setTitle("Relagent");

		//
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		pane.setLayout(new BorderLayout());

		//
		p1.add(a1);
		tabs = new JTabbedPaneWithCloseIcons();
		tabs.setComponentPopupMenu(p1);
		pane.add(tabs, BorderLayout.CENTER);

		//
		tbar = new JToolBar();
		pane.add(tbar, BorderLayout.NORTH);
		tbar.add(new AbstractAction("new query") {

			@Override
			public void actionPerformed(ActionEvent e) {
				SqlSchema s;

				if((s = getschema(tf1.getText())) != null) {
					tabs.add("query", new QueryPanel(s));
				}
			}

		});
		tbar.add(new AbstractAction("new editor") {

			@Override
			public void actionPerformed(ActionEvent e) {
				SqlSchema s;

				if((s = getschema(tf1.getText())) != null) {
					tabs.add("editor", new EditorPanel(s));
				}
			}

		});
		tf1 = new JTextField(50);
		tbar.add(tf1);
		tbar.add(new AbstractAction("file...") {

			@Override
			public void actionPerformed(ActionEvent e) {
				JFileChooser c = new JFileChooser();
				int x;

				c.setFileSelectionMode(
						JFileChooser.FILES_AND_DIRECTORIES);
				x = c.showOpenDialog(ZRelagent.this);
				if(x == JFileChooser.APPROVE_OPTION) {
					tf1.setText(c.getSelectedFile().toString());
				}
			}

		});

		//
		bar = new JMenuBar();
		mnu = new JMenu("File");
		mim = new JMenuItem("Exit");
		mim.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}

		});
		mnu.add(mim);
		bar.add(mnu);
		mnu = new JMenu("Help");
		mim = new JMenuItem("About ...");
		mim.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				JOptionPane.showMessageDialog(ZRelagent.this, HELP,
						"Relagent", JOptionPane.PLAIN_MESSAGE);
			}

		});
		mnu.add(mim);
		bar.add(mnu);
		setJMenuBar(bar);

		//
		setVisible(true);
	}

	SqlSchema getschema(String t) {
		SqlSchema s;
		File f;

		try {
			f = new File(t);
			if((s = RePlus.findSchema(f, 0)) == null) {
				JOptionPane.showMessageDialog(ZRelagent.this,
						"Database localtion must be required",
						"error",
						JOptionPane.ERROR_MESSAGE);
				return null;
			} else {
				return s;
			}
		} catch(IOException e1) {
			e1.printStackTrace();
			JOptionPane.showMessageDialog(ZRelagent.this,
					"",
					"IO error",
					JOptionPane.ERROR_MESSAGE);
			return null;
		} catch(SQLException e1) {
			e1.printStackTrace();
			JOptionPane.showMessageDialog(ZRelagent.this,
					e1.getMessage(),
					"IO error",
					JOptionPane.ERROR_MESSAGE);
			return null;
		}
	}

	public static void main(String[] args) {
		new ZRelagent();
	}

}
