/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlAlterTableAdd {

	//
	private String name;
	private List<SqlColumnDefinition> defs;

	public SqlAlterTableAdd(String n, List<SqlColumnDefinition> d) {
		name = n;
		defs = new ArrayList<SqlColumnDefinition>(d);
	}

	public String getName() {
		return name;
	}

	public List<SqlColumnDefinition> getColumnDefinitions() {
		return Collections.unmodifiableList(defs);
	}

	public List<String> getKeys() {
		List<String> l = new ArrayList<String>();

		for(SqlColumnDefinition d : defs) {
			if(d.getAttributes().contains(
					SqlColumnAttribute.PRIMARY_KEY)) {
				l.add(d.getName());
			}
		}
		return l;
	}

	public String toString() {
		StringBuffer b = new StringBuffer("ALTER TABLE ");
		String d = "\n  ";

		b.append(name).append(" ADD (");
		for(SqlColumnDefinition x : defs) {
			b.append(d).append(x);
			d = ",\n  ";
		}
		return b.append('\n').append(')').toString();
	}

}
