/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;

import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationFunction;

public abstract class FnUnary extends RelationFunction {

	@Override
	public final boolean isAggregate() {
		return false;
	}

	protected abstract Object operate(Object a);

	protected abstract String getName();

	@Override
	public Object operate(RelationAggregate m, List<Object> group,
			Object... args) throws SQLException {
		if(args.length != 1) {
			throw ErrorBundle.getDefault(10007, getName());
		}
		return operate(args[0]);
	}

	@Override
	public final Object init(RelationAggregate m) throws SQLException {
		throw new RuntimeException();
	}

}
