package net.morilib.db.schema;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.fichier.Fichier;
import net.morilib.db.fichier.SandboxBaseFichier;
import net.morilib.db.jdbc.RelationsJDBCUtils;
import net.morilib.db.misc.OSInfo;

public abstract class SqlSchemaFactory {

	private static Logger logger = RelationsJDBCUtils.logger;

	private static final String URI_T = "jdbc:relations:error";
	private static final String URI_S = "jdbc:relations:sandbox";
	private static final Pattern URI_LOCAL = Pattern.compile(
			"jdbc:relations://(/([^:/,]+)/(([^:/,]+/)*))");

	private static final SqlSchemaFactory
	_FAC = new SqlSchemaFactory() {

		@Override
		public SqlSchema getByURL(
				String url) throws IOException, SQLException {
			FabriqueDeFichier f;
			String s;

			if(url.equals(URI_T)) {
				return MemorySqlSchema.readProperties(
						"ERROR_MSG",
						"CODE",
						"MESSAGE",
						SqlSchemaFactory.class.getResourceAsStream(
								"/net/morilib/db/misc/relations_errors.properties"));
			} else if(url.equals(URI_S)) {
				f = new SandboxBaseFichier();
				return new FileSqlSchema(f, (Fichier)f);
			} else if((s = getlocal(url)) != null) {
				logger.finer(s);
				f = FabriqueDeFichier.getDefault();
				return new FileSqlSchema(f, f.newInstance(s));
			}
			return null;
		}

	};

	SqlSchemaFactory() { }

	//
	private static String getlocal(String url) {
		Matcher m;
		String s;

		if(!(m = URI_LOCAL.matcher(url)).matches()) {
			return null;
		} else if(!OSInfo.OS.isWindows()) {
			return m.group(1);
		} else if(m.group(3).length() == 0) {
			return null;
		} else if((s = m.group(2)).length() > 1) {
//			return "\\\\" + s + "\\" + m.group(3);
			return null;
		} else {
			return s + ":\\" + m.group(3);
		}
	}

	/**
	 * 
	 * @return
	 */
	public static SqlSchemaFactory getInstance() {
		return _FAC;
	}

	/**
	 * 
	 * @param url
	 * @return
	 */
	public abstract SqlSchema getByURL(
			String url) throws IOException, SQLException;

}
