/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.delay;

import java.sql.SQLException;

import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;

public abstract class OneValueDelay implements Delay {

	/**
	 * 
	 * @param c
	 */
	public abstract void add(Rational c) throws SQLException;

	/**
	 * 
	 * @param args
	 * @throws SQLException
	 */
	public void add(Object... args) throws SQLException {
		if(args.length == 1 && args[0] instanceof Rational) {
			add((Rational)args[0]);
		} else {
			throw ErrorBundle.getDefault(10035, args[0]);
		}
	}

}
