/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.schema;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;

import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;

public interface SqlSchema {

	/**
	 * 
	 * @param name
	 * @param as
	 * @return
	 * @throws SQLException
	 */
	public NamedRelation readRelation(String name,
			String as) throws IOException, SQLException;

	/**
	 * 
	 * @param name
	 * @param z
	 * @throws IOException
	 * @throws SQLException
	 */
	public void writeRelation(String name,
			Collection<RelationTuple> z
			) throws IOException, SQLException;

	/**
	 * 
	 * @param name
	 * @return
	 * @throws SQLException 
	 * @throws IOException 
	 */
	public SqlCreateTable getCreateTable(
			String name) throws IOException, SQLException;

	/**
	 * 
	 * @param name
	 * @return
	 * @throws SQLException 
	 * @throws IOException 
	 */
	public boolean isTable(
			String name) throws IOException, SQLException;

	/**
	 * 
	 * @param name
	 * @param table
	 * @throws IOException
	 * @throws SQLException
	 */
	public void putCreateTable(String name,
			SqlCreateTable table) throws IOException, SQLException;

	/**
	 * 
	 * @return
	 */
	public Collection<String> getTableNames(
			) throws IOException, SQLException;

	/**
	 * 
	 * @param name
	 * @throws IOException
	 * @throws SQLException
	 */
	public void truncateTable(
			String name) throws IOException, SQLException;

	/**
	 * 
	 * @param name
	 * @throws IOException
	 * @throws SQLException
	 */
	public void removeCreateTable(
			String name) throws IOException, SQLException;

	/**
	 * 
	 * @param name
	 * @param table
	 * @throws IOException
	 * @throws SQLException
	 */
	public void alterCreateTable(String name,
			SqlCreateTable table) throws IOException, SQLException;

	/**
	 * 
	 * @return
	 */
	public SqlSchema fork();

	/**
	 * 
	 * @return
	 */
	public NullBoolean isReadonly();

	/**
	 * 
	 * @return
	 */
	public NullBoolean usesLocalFiles();

	/**
	 * 
	 * @return
	 */
	public NullBoolean usesLocalFilePerTable();

	/**
	 * 
	 * @return
	 */
	public FabriqueDeFichier fabrique();

	/**
	 * 
	 * @param name
	 * @param r
	 */
	public void bindSchema(String name, Relation r);

	/**
	 * 
	 * @return
	 */
	public boolean isAutoCommit();

	/**
	 * 
	 * @param name
	 * @return
	 */
	public boolean isLocked(String name);

	/**
	 * 
	 * @param name
	 */
	public void lock(String name) throws IOException;

	/**
	 * 
	 * @param name
	 */
	public void unlock(String name) throws IOException;

}
