/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sqlcs.dml;

public class SqlJoin implements SqlRelation {

	private SqlJoinType type;
	private SqlRelation tbla, tblb;
	private SqlExpression on;

	public SqlJoin(SqlJoinType t, SqlRelation a, SqlRelation b,
			SqlExpression o) {
		type = t;  tbla = a;  tblb = b;  on = o;
	}

	public SqlJoinType getType() {
		return type;
	}

	public SqlRelation getJoinee() {
		return tbla;
	}

	public SqlRelation getJoiner() {
		return tblb;
	}

	public SqlExpression getOn() {
		return on;
	}

	public String toString() {
		StringBuffer b = new StringBuffer("(join ");

		b.append(type).append(' ');
		b.append(tbla).append(' ').append(tblb);
		if(on != null)  b.append(' ').append(on);
		b.append(')');
		return b.toString();
	}

}
