/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.sql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.sqlcs.dml.SqlSetBinaryOperation;
import net.morilib.db.sqlcs.dml.SqlSetBinaryOperator;
import net.morilib.db.sqlcs.dml.SqlSetExpression;

public class DbSqlSetParser {

	//
	private List<Object> stack = new ArrayList<Object>();
	private DbSqlNonterminal gt = null;
	private int stat;

	//
	private Object pop() {
		stack.remove(stack.size() - 1);
		return stack.remove(stack.size() - 1);
	}

	//
	private void shift(int n) {
		stat = n;
		gt   = null;
		stack.add(null);  stack.add(n);
	}

	//
//	private void shift(int n, Object o) {
//		stat = n;
//		gt   = null;
//		stack.add(o);  stack.add(n);
//	}

	//
	private void setGoto(DbSqlNonterminal nt, Object o) {
		stat = ((Integer)stack.get(stack.size() - 1)).intValue();
		gt   = nt;
		stack.add(o);
	}

	//
	private void goTo(int n) {
		stat = n;
		gt   = null;
		stack.add(n);
	}

	public SqlSetExpression parse(DbSqlLexer lex,
			Map<String, SqlSetExpression> t
			) throws IOException, SQLException {
		/* S -> E
		 * E -> ( E )
		 *    | E UNION E
		 *    | E UNION ALL E
		 *    | E MINUS|EXCEPT E
		 *    | E INTERSECT E
		 *    | E DIVIDE E
		 *    | <select>
		 */
		SqlSetExpression a, b;

		stack.add(stat = 100000);
		while(true) {
			switch(stat) {
			case 100000:
				/* S -> *E
				 * E -> *( E )
				 *    | *E UNION E
				 *    | *E UNION ALL E
				 *    | *E MINUS|EXCEPT E
				 *    | *E INTERSECT E
				 *    | *E DIVIDE E
				 *    | *<select>
				 */
				if(gt == DbSqlNonterminal.EXPR) {
					goTo(100100);
				} else if(lex.eqchar('(')) {
					shift(105100);
				} else if(lex.eqsym("SELECT")) {
					shift(130100);
				} else {
					throw ErrorBundle.getDefault(10019,
							lex.get().toString());
				}
				break;
			case 100100:
				/* S -> E*
				 * E -> E *UNION E
				 *    | E *UNION ALL E
				 *    | E *MINUS|EXCEPT E
				 *    | E *INTERSECT E
				 *    | E *DIVIDE E
				 */
				if(lex.eq(DbSqlReserved.UNION)) {
					shift(101100);
				} else if(lex.eq(DbSqlReserved.MINUS) ||
						lex.eq(DbSqlReserved.EXCEPT)) {
					shift(102100);
				} else if(lex.eq(DbSqlReserved.INTERSECT)) {
					shift(103100);
				} else if(lex.eq(DbSqlReserved.DIVIDE)) {
					lex.eqsym("BY");
					shift(104100);
				} else {
					return (SqlSetExpression)pop();
				}
				break;
			case 101100:
				/* E -> E UNION *E
				 *    | E UNION *ALL E
				 * E -> *( E )
				 *    | *E UNION E
				 *    | *E UNION ALL E
				 *    | *E MINUS|EXCEPT E
				 *    | *E INTERSECT E
				 *    | *E DIVIDE E
				 *    | *<select>
				 */
				if(gt == DbSqlNonterminal.EXPR) {
					goTo(101200);
				} else if(lex.eqchar('(')) {
					shift(105100);
				} else if(lex.eqsym("SELECT")) {
					shift(130100);
				} else if(lex.eqsym("ALL")) {
					shift(101210);
				} else {
					throw ErrorBundle.getDefault(10019,
							lex.get().toString());
				}
				break;
			case 101200:
				/* E -> E UNION E*
				 * E -> E *UNION E
				 *    | E *UNION ALL E
				 *    | E *MINUS|EXCEPT E
				 *    | E *INTERSECT E
				 *    | E *DIVIDE E
				 */
				if(lex.eq(DbSqlReserved.INTERSECT)) {
					shift(103100);
				} else if(lex.eq(DbSqlReserved.DIVIDE)) {
					lex.eqsym("BY");
					shift(104100);
				} else {
					b = (SqlSetExpression)pop();  pop();
					a = (SqlSetExpression)pop();
					setGoto(DbSqlNonterminal.EXPR,
							new SqlSetBinaryOperation(
									SqlSetBinaryOperator.UNION,
									a, b));
				}
				break;
			case 101210:
				/* E -> E UNION ALL *E
				 * E -> *( E )
				 *    | *E UNION E
				 *    | *E UNION ALL E
				 *    | *E MINUS|EXCEPT E
				 *    | *E INTERSECT E
				 *    | *E DIVIDE E
				 *    | *<select>
				 */
				if(gt == DbSqlNonterminal.EXPR) {
					goTo(101310);
				} else if(lex.eqchar('(')) {
					shift(105100);
				} else if(lex.eqsym("SELECT")) {
					shift(130100);
				} else {
					throw ErrorBundle.getDefault(10019,
							lex.get().toString());
				}
				break;
			case 101310:
				/* E -> E UNION ALL E*
				 * E -> E *UNION E
				 *    | E *UNION ALL E
				 *    | E *MINUS|EXCEPT E
				 *    | E *INTERSECT E
				 *    | E *DIVIDE E
				 */
				if(lex.eq(DbSqlReserved.INTERSECT)) {
					shift(103100);
				} else if(lex.eq(DbSqlReserved.DIVIDE)) {
					lex.eqsym("BY");
					shift(104100);
				} else {
					b = (SqlSetExpression)pop();  pop();  pop();
					a = (SqlSetExpression)pop();
					setGoto(DbSqlNonterminal.EXPR,
							new SqlSetBinaryOperation(
									SqlSetBinaryOperator.UNION_ALL,
									a, b));
				}
				break;
			case 102100:
				/* E -> E MINUS|EXCEPT *E
				 * E -> *( E )
				 *    | *E UNION E
				 *    | *E UNION ALL E
				 *    | *E MINUS|EXCEPT E
				 *    | *E INTERSECT E
				 *    | *E DIVIDE E
				 *    | *<select>
				 */
				if(gt == DbSqlNonterminal.EXPR) {
					goTo(102200);
				} else if(lex.eqchar('(')) {
					shift(105100);
				} else if(lex.eqsym("SELECT")) {
					shift(130100);
				} else {
					throw ErrorBundle.getDefault(10019,
							lex.get().toString());
				}
				break;
			case 102200:
				/* E -> E MINUS|EXCEPT E*
				 * E -> E *UNION E
				 *    | E *UNION ALL E
				 *    | E *MINUS|EXCEPT E
				 *    | E *INTERSECT E
				 *    | E *DIVIDE E
				 */
				if(lex.eq(DbSqlReserved.INTERSECT)) {
					shift(103100);
				} else if(lex.eq(DbSqlReserved.DIVIDE)) {
					lex.eqsym("BY");
					shift(104100);
				} else {
					b = (SqlSetExpression)pop();  pop();
					a = (SqlSetExpression)pop();
					setGoto(DbSqlNonterminal.EXPR,
							new SqlSetBinaryOperation(
									SqlSetBinaryOperator.MINUS,
									a, b));
				}
				break;
			case 103100:
				/* E -> E INTERSECT *E
				 * E -> *( E )
				 *    | *E UNION E
				 *    | *E UNION ALL E
				 *    | *E MINUS|EXCEPT E
				 *    | *E INTERSECT E
				 *    | *E DIVIDE E
				 *    | *<select>
				 */
				if(gt == DbSqlNonterminal.EXPR) {
					goTo(103200);
				} else if(lex.eqchar('(')) {
					shift(105100);
				} else if(lex.eqsym("SELECT")) {
					shift(130100);
				} else {
					throw ErrorBundle.getDefault(10019,
							lex.get().toString());
				}
				break;
			case 103200:
				/* E -> E INTERSECT E*
				 * E -> E *UNION E
				 *    | E *UNION ALL E
				 *    | E *MINUS|EXCEPT E
				 *    | E *INTERSECT E
				 *    | E *DIVIDE E
				 */
				b = (SqlSetExpression)pop();  pop();
				a = (SqlSetExpression)pop();
				setGoto(DbSqlNonterminal.EXPR,
						new SqlSetBinaryOperation(
								SqlSetBinaryOperator.INTERSECT,
								a, b));
				break;
			case 104100:
				/* E -> E DIVIDE *E
				 * E -> *( E )
				 *    | *E UNION E
				 *    | *E UNION ALL E
				 *    | *E MINUS|EXCEPT E
				 *    | *E INTERSECT E
				 *    | *E DIVIDE E
				 *    | *<select>
				 */
				if(gt == DbSqlNonterminal.EXPR) {
					goTo(104200);
				} else if(lex.eqchar('(')) {
					shift(105100);
				} else if(lex.eqsym("SELECT")) {
					shift(130100);
				} else {
					throw ErrorBundle.getDefault(10019,
							lex.get().toString());
				}
				break;
			case 104200:
				/* E -> E DIVIDE E*
				 * E -> E *UNION E
				 *    | E *UNION ALL E
				 *    | E *MINUS|EXCEPT E
				 *    | E *INTERSECT E
				 *    | E *DIVIDE E
				 */
				b = (SqlSetExpression)pop();  pop();
				a = (SqlSetExpression)pop();
				setGoto(DbSqlNonterminal.EXPR,
						new SqlSetBinaryOperation(
								SqlSetBinaryOperator.DIVIDE,
								a, b));
				break;
			case 105100:
				/* E -> ( *E )
				 * E -> *( E )
				 *    | *E UNION E
				 *    | *E UNION ALL E
				 *    | *E MINUS|EXCEPT E
				 *    | *E INTERSECT E
				 *    | *E DIVIDE E
				 *    | *<select>
				 */
				if(gt == DbSqlNonterminal.EXPR) {
					goTo(105200);
				} else if(lex.eqchar('(')) {
					shift(105100);
				} else if(lex.eqsym("SELECT")) {
					shift(130100);
				} else {
					throw ErrorBundle.getDefault(10019,
							lex.get().toString());
				}
				break;
			case 105200:
				/* E -> ( E *)
				 * E -> E *UNION E
				 *    | E *UNION ALL E
				 *    | E *MINUS|EXCEPT E
				 *    | E *INTERSECT E
				 *    | E *DIVIDE E
				 */
				if(lex.eqchar(')')) {
					shift(105300);
				} else if(lex.eq(DbSqlReserved.UNION)) {
					shift(101100);
				} else if(lex.eq(DbSqlReserved.MINUS) ||
						lex.eq(DbSqlReserved.EXCEPT)) {
					shift(102100);
				} else if(lex.eq(DbSqlReserved.INTERSECT)) {
					shift(103100);
				} else if(lex.eq(DbSqlReserved.DIVIDE)) {
					lex.eqsym("BY");
					shift(104100);
				} else {
					throw ErrorBundle.getDefault(10019,
							lex.get().toString());
				}
				break;
			case 105300:
				/* E -> ( E )*
				 */
				pop();  a = (SqlSetExpression)pop();  pop();
				setGoto(DbSqlNonterminal.EXPR, a);
				break;
			case 130100:
				/* E -> <select-clause>*
				 */
				pop();
				setGoto(DbSqlNonterminal.EXPR,
						new DbSqlParser()._select(lex, t));
				break;
			}
		}
	}

}
