/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.map;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import net.morilib.db.expr.RelationExpression;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.parser.csv.CSVConfig;
import net.morilib.parser.csv.CSVException;
import net.morilib.parser.csv.StringCSVPullParser;

public class CSVDataMapper implements SqlDataMapper {

	//
	private static final CSVConfig DEFT =
			new CSVConfig(",", '\"', false);

	/**
	 * 
	 * @param name
	 * @param as
	 * @param t
	 * @param cfg
	 * @param rd
	 * @return
	 * @throws IOException
	 * @throws SQLException
	 */
	public static SingleTableRelation read(String name, String as,
			SqlCreateTable t, CSVConfig cfg,
			Reader rd) throws IOException, SQLException {
		Collection<RelationTuple> l = new ArrayList<RelationTuple>();
		StringCSVPullParser p = new StringCSVPullParser(rd, cfg);
		Map<String, Object> m = new LinkedHashMap<String, Object>();
		List<String> n = new ArrayList<String>();
		SqlColumnDefinition d;
		String[] a;
		Object o;

		for(int i = 0; i < t.getColumnDefinitions().size(); i++) {
			n.add(t.getColumnDefinitions().get(i).getName());
		}

		try {
			while(p.next()) {
				a = p.get();
				for(int i = 0; i < t.getColumnDefinitions().size(); i++) {
					d = t.getColumnDefinitions().get(i);
					if(a[i].equals(RelationExpression.NULL)) {
						o = a[i];
					} else {
						o = d.getType().cast(a[i]);
					}
					m.put(d.getName(), o);
				}
				l.add(new DefaultRelationTuple(m));
			}
			return new SingleTableRelation(t, as, l);
		} catch(CSVException e) {
			throw new IOException(e);
		} finally {
			p.close();
		}
	}

	public SingleTableRelation read(String name, String as,
			SqlCreateTable t,
			Reader rd) throws IOException, SQLException {
		return read(name, as, t, DEFT, rd);
	}

	@Override
	public void write(String name, SqlCreateTable t, PrintWriter w,
			Collection<RelationTuple> l
			) throws IOException, SQLException {
		List<String> n = new ArrayList<String>();
		List<SqlColumnDefinition> f;
		String d, v;
		Object o;

		for(int i = 0; i < t.getColumnDefinitions().size(); i++) {
			n.add(t.getColumnDefinitions().get(i).getName());
		}

		f = t.getColumnDefinitions();
		try {
			for(RelationTuple p : l) {
				d = "";
				for(int i = 0; i < f.size(); i++) {
					v = p.get(f.get(i).getName()).toString();
					o = f.get(i).getType().cast(v);
					v = f.get(i).getType().string(o);
					w.print(d);
					w.print('\"');
					w.print(v.replaceAll("\"", "\"\""));
					w.print('\"');
					d = ",";
				}
				w.println();
			}
		} finally {
			w.flush();
			w.close();
		}
	}

}
