/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.fichier;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public interface Fichier {

	/**
	 * 
	 * @return
	 */
	public boolean isFile();

	/**
	 * 
	 */
	public boolean createNewFile() throws IOException;

	/**
	 * 
	 * @return
	 */
	public Reader openReader() throws IOException;

	/**
	 * 
	 * @return
	 */
	public Writer openWriter() throws IOException;

	/**
	 * 
	 * @return
	 */
	public InputStream openInputStream() throws IOException;

	/**
	 * 
	 * @return
	 */
	public OutputStream openOutputStream() throws IOException;

	/**
	 * 
	 * @return
	 */
	public String getName();

	/**
	 * 
	 * @return
	 */
	public boolean delete() throws IOException;

	/**
	 * 
	 * @return
	 */
	public Fichier[] listFichiers();

	/**
	 * 
	 * @param name
	 * @return
	 */
	public boolean renameTo(Fichier name) throws IOException;

}
