/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import net.morilib.db.delay.Delay;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;

public class RelationIn extends RelationExpression {

	//
	private RelationExpression exp;
	private List<RelationExpression> ins;

	public RelationIn(RelationExpression e,
			List<RelationExpression> in) {
		exp = e;
		ins = new ArrayList<RelationExpression>(in);
	}

	@Override
	public Object eval(SqlEngine v, SqlSchema f,
			RelationTuple tuple, RelationAggregate m,
			List<String> g,
			List<Object> h) throws IOException, SQLException {
		final Object o = exp.eval(v, f, tuple, m, g, h);
		final Object[] a = new Object[ins.size()];
		Delay b = null;

		for(int i = 0; i < ins.size(); i++) {
			a[i] = ins.get(i).eval(v, f, tuple, m, g, h);
			if(a[i] instanceof Delay) {
				b = (Delay)a[i];
				break;
			}
		}

		if(o instanceof Delay) {
			return o;
		} else if(b != null) {
			return b;
		} else {
			for(int i = 0; i < ins.size(); i++) {
				if(o.equals(a[i]))  return TRUE;
			}
			return FALSE;
		}
	}

	public boolean isAggregate() throws SQLException {
		for(RelationExpression e : ins) {
			if(e.isAggregate())  return true;
		}
		return exp.isAggregate();
	}

	@Override
	public Object init(SqlEngine v, SqlSchema f) throws SQLException {
		final Object o = exp.init(v, f);
		final Object[] a = new Object[ins.size()];
		boolean b = false;

		for(int i = 0; i < ins.size(); i++) {
			a[i] = ins.get(i).init(v, f);
			b = b || a[i] instanceof Delay;
		}

		if(o instanceof Delay) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					Object p = ((Delay)o).force(), q;

					for(int i = 0; i < ins.size(); i++) {
						q = a[i] instanceof Delay ?
								((Delay)a[i]).force() : a[i];
						if(p.equals(q))  return TRUE;
					}
					return FALSE;
				}

				@Override
				public void add(Object... args) throws SQLException {
					((Delay)o).add(args);
					for(int i = 0; i < ins.size(); i++) {
						if(a[i] instanceof Delay) {
							((Delay)a[i]).add(args);
						}
					}
				}

			};
		} else if(b) {
			return new Delay() {

				@Override
				public Object force() throws SQLException {
					Object q;

					for(int i = 0; i < ins.size(); i++) {
						q = a[i] instanceof Delay ?
								((Delay)a[i]).force() : a[i];
						if(o.equals(q))  return TRUE;
					}
					return FALSE;
				}

				@Override
				public void add(Object... args) throws SQLException {
					for(int i = 0; i < ins.size(); i++) {
						if(a[i] instanceof Delay) {
							((Delay)a[i]).add(args);
						}
					}
				}

			};
		} else {
			for(int i = 0; i < ins.size(); i++) {
				if(o.equals(ins.get(i)))  return TRUE;
			}
			return FALSE;
		}
	}

}
