/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.relations;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import net.morilib.db.expr.RelationExpression;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class OuterRelationTuple implements RelationTuple {

	private Relation rel;
	private RelationTuple tuple;
	private List<SqlColumnDefinition> nulls;

	public OuterRelationTuple(Relation r, RelationTuple t,
			List<SqlColumnDefinition> s) throws SQLException {
		rel = r;
		tuple = t;
		nulls = new ArrayList<SqlColumnDefinition>(s);
	}

	public Object get(String name) throws SQLException {
		Object o;

		if((o = Relations._get(tuple, rel, name)) != null) {
			return o;
		} else if(nulls.contains(name)) {
			return RelationExpression.NULL;
		} else {
			throw ErrorBundle.getDefault(10009, name);
		}
	}

	@Override
	public RelationTuple copy() throws SQLException {
		return new DefaultRelationTuple(toMap());
	}

	@Override
	public Map<String, Object> toMap() throws SQLException {
		Map<String, Object> m, t;

		t = tuple.toMap();
		m = new LinkedHashMap<String, Object>();
		for(SqlColumnDefinition s : nulls)  m.put(s.getName(), "");
		for(String s : t.keySet()) {
			if(!(rel instanceof SingleTableRelation)) {
				m.put(s, t.get(s));
			} else {
				m.put(((SingleTableRelation)rel).getName() + "." + s,
						t.get(s));
			}
		}
		return m;
	}

}
