/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.functions;

import java.sql.SQLException;
import java.util.List;

import net.morilib.db.delay.Delay;
import net.morilib.db.expr.RelationFunction;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;

public class FnRound extends RelationFunction {

	private static Rational rnd(Object o,
			Object p) throws SQLException {
		int x;

		if(!(o instanceof Rational &&
				p instanceof Rational)) {
			throw ErrorBundle.getDefault(10008, "ROUND");
		} else if(!((Rational)p).isInteger()) {
			throw ErrorBundle.getDefault(10008, "ROUND");
		} else {
			x = ((Rational)p).intCeil();
//			x = x > 0 ? x + 1 : x;
			return Rational.valueOf(((Rational)o).toBigDecimal(x));
		}
	}

	@Override
	public boolean isAggregate() {
		return false;
	}

	@Override
	public Object operate(RelationAggregate m, List<Object> group,
			final Object... args) throws SQLException {
		if(args.length == 1) {
			if(args[0] instanceof Delay) {
				Delay d = new Delay() {

					@Override
					public Object force() throws SQLException {
						Object o;

						o = ((Delay)args[0]).force();
						return rnd(o, Rational.ZERO);
					}

					@Override
					public void add(Object... o) throws SQLException {
						((Delay)args[0]).add(o);
					}

				};

				m.put(group, d);
				return d;
			} else {
				return rnd(args[0], Rational.ZERO);
			}
		} else if(args.length == 2) {
			if(args[0] instanceof Delay) {
				Delay d = new Delay() {

					@Override
					public Object force() throws SQLException {
						Object o, p;

						o = ((Delay)args[0]).force();
						p = args[1] instanceof Delay ? 
								((Delay)args[1]).force() : args[1];
						return rnd(o, p);
					}

					@Override
					public void add(Object... o) throws SQLException {
						((Delay)args[0]).add(o);
					}

				};
				m.put(group, d);
				return d;
			} else {
				return rnd(args[0], args[1]);
			}
		} else {
			throw ErrorBundle.getDefault(10007, "ROUND");
		}
	}

	@Override
	public Object init(RelationAggregate m) throws SQLException {
		return Rational.ZERO;
	}

	@Override
	public FunctionType getType() {
		return FunctionType.NUMERIC;
	}

}
