/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.db.gui;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.swing.table.AbstractTableModel;

import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/08/24
 */
public class RelationEditorTableModel extends AbstractTableModel {

	private List<SqlColumnDefinition> head;
	private List<RelationTuple> list;
	private boolean dirty = false;
	private Object[] inst;
	private String name;

	/**
	 * 
	 * @param r
	 * @throws SQLException 
	 * @throws IOException 
	 */
	public RelationEditorTableModel(String n,
			Relation r) throws IOException, SQLException {
		RelationCursor c;

		name = n;
		head = r.getColumnNames();
		list = new ArrayList<RelationTuple>();
		c = r.iterator();
		while(c.hasNext())  list.add(c.next());
		inst = null;
	}

	@Override
	public int getRowCount() {
		return list.size() + 1;
	}

	@Override
	public int getColumnCount() {
		return head.size();
	}

	@Override
	public String getColumnName(int columnIndex) {
		return head.get(columnIndex).getName();
	}

	@Override
	public Class<?> getColumnClass(int columnIndex) {
		return head.get(columnIndex).getName().getClass();
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return true;
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		Iterator<Map.Entry<String, Object>> itr;
		Map<String, Object> m;

		if(rowIndex == list.size()) {
			return inst != null ? inst[columnIndex] : "";
		} else {
			try {
				m = list.get(rowIndex).toMap();
				itr = m.entrySet().iterator();
				for(int i = 0; i < columnIndex; i++, itr.next());
				return itr.next().getValue();
			} catch (SQLException e) {
				return "(fail to get)";
			}
		}
	}

	@Override
	public void setValueAt(Object aValue, int rowIndex,
			int columnIndex) {
		Iterator<Map.Entry<String, Object>> itr;
		Map<String, Object> m;

		if(rowIndex < list.size()) {
			try {
				m = new LinkedHashMap<String, Object>(
						list.get(rowIndex).toMap());
				itr = m.entrySet().iterator();
				for(int i = 0; i < columnIndex; i++, itr.next());
				itr.next().setValue(aValue);
				list.set(rowIndex, new DefaultRelationTuple(m));
			} catch (SQLException e) {
				// do nothing
			}
		} else {
			if(inst == null)  inst = new Object[head.size()];
			inst[columnIndex] = aValue;
		}
		dirty = true;
	}

	public void write(SqlSchema f) throws IOException, SQLException {
		if(inst != null)  insertTuple();
		if(dirty)  f.writeRelation(name, list);
		dirty = false;
	}

	public void insertTuple() {
		Map<String, Object> m;

		m = new LinkedHashMap<String, Object>();
		for(int i = 0; i < inst.length; i++) {
			m.put(head.get(i).getName(),
					inst[i] != null ? inst[i] : "");
		}
		list.add(new DefaultRelationTuple(m));
		inst = null;
		fireTableRowsInserted(list.size() - 2, list.size() - 1);
	}

	public void deleteTuple(int row) {
		list.remove(row);
		dirty = true;
		fireTableRowsDeleted(row, row);
	}

}
