------------------------------------------------------------------------------
-- Copyright 2018 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with Referencing.Types;
with Referencing.References;
with Referencing.Types.Operations;

package Referencing.Tester is

   ----------------------
   -- Sample_Reference --
   ----------------------

   type Sample_Reference is tagged private;

   Null_Sample_Reference : constant Sample_Reference;

   type Sample_Limited_Reference
     (Data : not null access Sample_Reference) is
     limited private
     with Implicit_Dereference => Data;

   function Assigned
     (Object : Sample_Reference'Class)
     return Boolean
     with Inline_Always;

   procedure Assign
     (Target : in out Sample_Reference'Class;
      Source : Sample_Reference'Class)
     with Inline_Always;

   procedure Move
     (Target : in out Sample_Reference'Class;
      Source : in out Sample_Reference'Class)
     with Inline_Always;

   function Construct_Result
     return Sample_Limited_Reference
     with Inline_Always;

   function Create
     (Value : Integer)
     return Sample_Limited_Reference
     with Inline_Always;

   function Plus
     (Left, Right : Sample_Reference'Class)
     return Sample_Limited_Reference
     with Inline_Always;

   -----------
   -- Types --
   -----------

   package Types is

      -----------------------
      -- Sample_Referenced --
      -----------------------

      type Sample_Referenced is
        new Referencing.Types.Referenced with
      record
         Value_Field : Integer := 0;
      end record;

      procedure Create
        (Object : access Sample_Referenced;
         Value : Integer);

      function Plus
        (Left : access Sample_Referenced;
         Right : Sample_Reference'Class)
         return Sample_Limited_Reference;

      -------------------
      -- Sample_Access --
      -------------------

      type Sample_Access is access all Sample_Referenced'Class;

      function Get
        (Object : in Sample_Reference'Class)
        return Sample_Access
        with Inline_Always;

      function Create_And_Retain
        (Object : Sample_Access)
        return Sample_Limited_Reference
        with Inline_Always;

   private
      overriding
      procedure Initialize (Object : in out Sample_Referenced);

      overriding
      procedure Finalize (Object : in out Sample_Referenced);

      package Sample_Referenced_Parents renames Referencing.Types;
      subtype Sample_Referenced_Parent is Referencing.Types.Referenced;
   end Types;

private

   function Upcast
     (Object : Types.Sample_Access)
     return Referencing.Types.Operations.Referenced_Access
     with Inline_Always;

   package References is
     new Referencing.References
       (Types.Sample_Access, null);

   type Sample_Reference is
     new References.Reference_Base
     with null record;

   Null_Sample_Reference : constant Sample_Reference :=
     (References.Reference_Base with null record);

   package Operations is
     new References.Operations
     (Sample_Reference);

   type Sample_Limited_Reference
     (Data : not null access Sample_Reference) is
     new Operations.Limited_Reference_Base
     (Data => Data);

end Referencing.Tester;
