------------------------------------------------------------------------------
-- Copyright 2018 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with Ada.Text_IO;

procedure Referencing.Tester.Main is

   Value_1 : Sample_Reference renames Create (2);
   Value_2 : Sample_Reference renames Create (4);
   Value_3 : Sample_Reference renames Plus (Value_1, Value_2);

   function Unlimited_Plus (Left, Right : Sample_Reference) return Sample_Reference is
   begin
      return Result : Sample_Reference do
         Ada.Text_IO.Put_Line ("...");
         Result.Move (Plus (Left, Right));
         Ada.Text_IO.Put_Line ("...");
      end return;
   end Unlimited_Plus;

begin
   Ada.Text_IO.Put_Line ("begin");
   Value_2.Move (Plus (Value_2, Value_3));
   Ada.Text_IO.Put_Line ("------------------------");
   Value_1 := Value_3;
   Ada.Text_IO.Put_Line ("---------- := ----------");
   Value_1 := Plus (Value_1, Value_1);
   Ada.Text_IO.Put_Line ("---------- := ----------");
   Value_1 := Unlimited_Plus (Value_1, Value_1);
   Ada.Text_IO.Put_Line ("-------- Assign --------");
   Value_1.Assign (Plus (Value_1, Value_1));
   Ada.Text_IO.Put_Line ("--------- Move ---------");
   Value_1.Move (Plus (Value_1, Value_1));
   Ada.Text_IO.Put_Line ("end");
end Referencing.Tester.Main;
