------------------------------------------------------------------------------
-- Copyright 2018 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with Ada.Finalization;
private with System.Atomic_Counters;

package Referencing.Types with Pure, Preelaborate is

   type Referenced is new Ada.Finalization.Limited_Controlled with private;

private

   type Referenced is new Ada.Finalization.Limited_Controlled with record
      Counter : System.Atomic_Counters.Atomic_Counter;
   end record;

end Referencing.Types;
