------------------------------------------------------------------------------
-- Copyright 2018 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with Ada.Unchecked_Deallocation;
with System.Address_To_Access_Conversions;

package Referencing.Types.Operations with Preelaborate is

   package Conversions is new System.Address_To_Access_Conversions (Object => Referenced'Class);
   subtype Referenced_Access is Conversions.Object_Pointer;
   procedure Free is new Ada.Unchecked_Deallocation (Object => Referenced'Class, Name => Referenced_Access);
   function To_Access (Value : System.Address) return Referenced_Access
     renames Conversions.To_Pointer;
   function To_Address (Value : Referenced_Access) return System.Address
     renames Conversions.To_Address;

   function Is_Unique (Object : Referenced'Class) return Boolean with Inline_Always;
   procedure Retain (Object : in out Referenced'Class) with Inline_Always;
   function Release (Object : in out Referenced'Class) return Boolean with Inline_Always;

end Referencing.Types.Operations;
