﻿------------------------------------------------------------------------------
-- Copyright 2018 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with System.Atomic_Counters;

package body Referencing.Types.Operations is

   ---------------
   -- Is_Unique --
   ---------------

   function Is_Unique (Object : Referenced'Class) return Boolean is
   begin
      return System.Atomic_Counters.Is_One (Object.Counter);
   end Is_Unique;

   ------------
   -- Retain --
   ------------

   procedure Retain (Object : in out Referenced'Class) is
   begin
      System.Atomic_Counters.Increment (Object.Counter);
   end Retain;

   -------------
   -- Release --
   -------------

   function Release (Object : in out Referenced'Class) return Boolean is
   begin
      return System.Atomic_Counters.Decrement (Object.Counter);
   end Release;

end Referencing.Types.Operations;
