------------------------------------------------------------------------------
-- Copyright 2018 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with Referencing.Types;
with Ada.Finalization;

with Referencing.Types.Operations;

generic
   type Classwide_Access is private;
   Null_Access : in Classwide_Access;
   with function Upcast (Object : Classwide_Access) return Types.Operations.Referenced_Access is <>;
package Referencing.References with Preelaborate is

   type Reference_Base is tagged private;

   ----------------
   -- Operations --
   ----------------

   generic
      type Reference is new Reference_Base with private;
   package Operations is

      function Assigned
        (Object : Reference'Class)
        return Boolean
        with Inline_Always;

      procedure Assign
        (Target : in out Reference'Class;
         Source : Reference'Class)
        with Inline_Always;

      procedure Move
        (Target : in out Reference'Class;
         Source : in out Reference'Class)
        with Inline_Always;

      function Get
        (Object : in Reference'Class)
        return Classwide_Access
        with Inline_Always;

      procedure Set
        (Object : in out Reference'Class;
         Item : Classwide_Access)
        with Inline_Always;
   
      procedure Set_And_Retain
        (Object : in out Reference'Class;
         Item : Classwide_Access)
        with Inline_Always;

      -----------------------
      -- Limited_Reference --
      -----------------------

      type Limited_Reference_Base
        (Data : not null access Reference) is
        limited private
        with Implicit_Dereference => Data;
      
      function Create_Limited_Reference
        return Limited_Reference_Base
        with Inline_Always;

      function Create_And_Retain
        (Object : Classwide_Access)
        return Limited_Reference_Base
        with Inline_Always;

   private
      type Limited_Reference_Base
        (Data : not null access Reference) is
      limited record
         Wrapped : aliased Reference;
      end record;
   end Operations;

private

   type Reference_Base is new Ada.Finalization.Controlled with record
      Internal_Access : Classwide_Access := Null_Access;
   end record;

   overriding
   procedure Adjust (Object : in out Reference_Base) with Inline;

   overriding
   procedure Finalize (Object : in out Reference_Base) with Inline;

end Referencing.References;
