------------------------------------------------------------------------------
-- Copyright 2019 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
------------------------------------------------------------------------------

with Ada.Text_IO;
with System.Atomic_Counters;

procedure Experiments.Hello is
   use Ada.Text_IO;
   use System.Atomic_Counters;

   X : Atomic_Counter;
   Y : Atomic_Unsigned := 0;
begin
   Increment (X);
   if Decrement (X) then
      Put_Line ("Atomic_Counter FAIL 1");
   else
      if Decrement (X) then
         Put_Line ("Atomic_Counter PASS");
      else
         Put_Line ("Atomic_Counter FAIL 2");
      end if;
   end if;

   Increment (Y);
   Increment (Y);
   Decrement (Y);

   if Decrement (Y) then
      Put_Line ("Atomic_Unsigned PASS");
   else
      Put_Line ("Atomic_Unsigned FAIL");
   end if;

end Experiments.Hello;
