/****************************************************************************\
** Copyright 2019 Levashev Ivan Aleksandrovich                              **
**                                                                          **
** Licensed under the Apache License, Version 2.0 (the "License");          **
** you may not use this file except in compliance with the License.         **
** You may obtain a copy of the License at                                  **
**                                                                          **
**     http://www.apache.org/licenses/LICENSE-2.0                           **
**                                                                          **
** Unless required by applicable law or agreed to in writing, software      **
** distributed under the License is distributed on an "AS IS" BASIS,        **
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. **
** See the License for the specific language governing permissions and      **
** limitations under the License.                                           **
\****************************************************************************/

/*
  This header provides atomic counter macros for AdaMagic combined with
  C/C++ compiler supporting Itanium ABI atomics. Support can be further 
  enhanced by tweaking this file.
*/

#ifndef H__ada_magic_forward__atomic_counters_h
#define H__ada_magic_forward__atomic_counters_h

#ifdef __cplusplus

#define Ada_magic_forward_Atomic_counters_Increment(Item) __sync_add_and_fetch(&(((::Ada_magic_forward::Atomic_counters::Atomic_counter *)(Item))->Value), 1U)
#define Ada_magic_forward_Atomic_counters_Decrement(Item) ((Boolean )(__sync_sub_and_fetch(&(((::Ada_magic_forward::Atomic_counters::Atomic_counter *)(Item))->Value), 1U) == 0U))
#define Ada_magic_forward_Atomic_counters_Is_one(Item) ((Boolean )(((::Ada_magic_forward::Atomic_counters::Atomic_counter *)(Item))->Value == 1U))
#define Ada_magic_forward_Atomic_counters_Initialize(Item) ((::Ada_magic_forward::Atomic_counters::Atomic_counter *)(Item))->Value = 1U

#define Ada_magic_forward_Atomic_counters_Unsigned_Increment(Item) __sync_add_and_fetch((::Ada_magic_forward::Atomic_counters::Unsigned::Atomic_unsigned *)(Item), 1U)
#define Ada_magic_forward_Atomic_counters_Unsigned_Decrement(Item) ((Boolean )(__sync_sub_and_fetch(((::Ada_magic_forward::Atomic_counters::Unsigned::Atomic_unsigned *)(&(Item))), 1U) == 0U))
#define Ada_magic_forward_Atomic_counters_Unsigned_addon_Decrement(Item) __sync_sub_and_fetch((::Ada_magic_forward::Atomic_counters::Unsigned_addon::Atomic_unsigned *)(Item), 1U)

#else

#define Ada_magic_forward_Atomic_counters_Increment(Item) __sync_add_and_fetch(&(((Ada_magic_forward_Atomic_counters_Atomic_counter *)(Item))->Value), 1U)
#define Ada_magic_forward_Atomic_counters_Decrement(Item) ((Boolean )(__sync_sub_and_fetch(&(((Ada_magic_forward_Atomic_counters_Atomic_counter *)(Item))->Value), 1U) == 0U))
#define Ada_magic_forward_Atomic_counters_Is_one(Item) ((Boolean )(((Ada_magic_forward_Atomic_counters_Atomic_counter *)(Item))->Value == 1U))
#define Ada_magic_forward_Atomic_counters_Initialize(Item) ((Ada_magic_forward_Atomic_counters_Atomic_counter *)(Item))->Value = 1U

#define Ada_magic_forward_Atomic_counters_Unsigned_Increment(Item) __sync_add_and_fetch((Ada_magic_forward_Atomic_counters_Unsigned_Atomic_unsigned *)(Item), 1U)
#define Ada_magic_forward_Atomic_counters_Unsigned_Decrement(Item) ((Boolean )(__sync_sub_and_fetch(((Ada_magic_forward_Atomic_counters_Unsigned_Atomic_unsigned *)(&(Item))), 1U) == 0U))
#define Ada_magic_forward_Atomic_counters_Unsigned_addon_Decrement(Item) __sync_sub_and_fetch((Ada_magic_forward_Atomic_counters_Unsigned_addon_Atomic_unsigned *)(Item), 1U)

#endif

#endif
