class RedmineLeSettingsController < ApplicationController
  unloadable
  before_filter :require_admin

  def index
    @setting = RedmineLeSetting.instance
  end

  def update
    @setting = RedmineLeSetting.instance
    @setting.update_attributes(params[:redmine_le_setting])
    if @setting.save
      flash[:notice] = l(:notice_successful_update)
      flash[:warning] = l(:warning_need_to_restart)
      redirect_to :action => 'index'
    else
      render :action => 'index'
    end
  end
end
