#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import datetime
import os
import shutil

import chdb
import n_gram
import rec10d
import ts2epg
import xml2db
import configreader
path = str(os.path.dirname(os.path.abspath(__file__))) + "/"
tmppath = configreader.getpath("tmp")+"/"
if tmppath=="":
    tmppath=path
def update(chtxt):
    print chtxt
    tnow = datetime.datetime.now()
    try:
        lastup = datetime.datetime.strptime(chdb.chtxtsearch(chtxt)[0]['update'], "%Y-%m-%d %H:%M:%S")
    except:
        lastup = datetime.datetime.strptime("2009-04-01 00:00:00", "%Y-%m-%d %H:%M:%S")
    dt = tnow-lastup
    dt = dt.days * 24 * 60 + dt.seconds
    if dt > 2 * 60 * 60:
        ts2epg.write(tmppath + chtxt + "epgdata.xml", chdb.chtxtsearch(chtxt)['ch'])
        xml2db.xml2db(tmppath + chtxt + "epgdata.xml", chdb.chtxtsearch(chtxt)['bctype'])
def updatebc(bctype):
    bctypel = chdb.bctypesearch(bctype)
    print bctypel
    try:
        ts2epg.write(tmppath + bctype + "epgdata.xml", chdb.bctypesearch(bctype)['ch'])
        xml2db.xml2db(tmppath + bctype + "epgdata.xml", bctype)
        shutil.copyfile(tmppath + bctype + "epgdata.xml", tmppath + bctype + "epgdata.bak.xml")
        rec10d.rec10db.update_by_bctype_epg_ch(bctype)
    except Exception, inst:
        print type(inst)
        print inst
        xml2db.xml2db(tmppath + bctype + "epgdata.bak.xml", bctype)
        rec10d.rec10db.update_status_by_bctype_epg_ch(bctype, "2")
def updatebc_bak(bctype):
    """
    update epg data by .bak file
    """
    xml2db.xml2db(tmppath + bctype + "epgdata.bak.xml", bctype)
def searchtime2(titletxt, timet, deltatime, chtxt):
    time = datetime.datetime.strptime(timet, "%Y-%m-%d %H:%M:%S")
    ret = []
    deltatime = int(deltatime)
    beforetime = time.strftime("%Y%m%d%H%M%S")
    aftertime = time + datetime.timedelta(hours=deltatime)
    aftertime = aftertime.strftime("%Y%m%d%H%M%S")
    one = ["", "", "", ""]
    tempt = 0
    d = rec10d.rec10db.select_by_time_ngram_epg_timeline(beforetime, aftertime, chtxt)
    for chtxtt, title, start, stop ,exp,longexp,category in d:
        #print chtxtt+":"+title+":"+start+":"+stop
        p = n_gram.bigram(titletxt, title)
        btime = start
        btime = btime[0:4] + "-" + btime[4:6] + "-" + btime[6:8] + " " + btime[8:10] + ":" + btime[10:12] + ":00"
        etime = stop
        etime = etime[0:4] + "-" + etime[4:6] + "-" + etime[6:8] + " " + etime[8:10] + ":" + etime[10:12] + ":00"
        bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
        dt = bt-time
        dt = 24 * 60 * 60 * dt.days + dt.seconds + 1
        p = p * 90
        dt = 1000-1000 * dt / (7 * 24 * 60 * 60)
        if p > 0:
            p = p + dt
            print dt
        if p > tempt:
            one = [chtxtt, title.encode('utf-8'), btime, etime,exp.encode('UTF-8'),longexp.encode('UTF-8'),category.encode('UTF-8')]
            tempt = p
        if p > 0:
            print title + ":" + str(p) + "点"
    ret = one
    print ret
    return ret
def searchtime_auto(keytxt, timet, deltatime):
    time = datetime.datetime.strptime(timet, "%Y-%m-%d %H:%M:%S")
    ret = []
    deltatime = int(deltatime)
    beforetime = time.strftime("%Y%m%d%H%M%S")
    aftertime = time + datetime.timedelta(hours=deltatime)
    aftertime = aftertime.strftime("%Y%m%d%H%M%S")
    d = rec10d.rec10db.select_by_time_auto_suggest_epg_timeline(keytxt,beforetime, aftertime)
    for chtxtt, title, start, stop ,exp,longexp,category in d:
        btime = start
        btime = btime[0:4] + "-" + btime[4:6] + "-" + btime[6:8] + " " + btime[8:10] + ":" + btime[10:12] + ":00"
        etime = stop
        etime = etime[0:4] + "-" + etime[4:6] + "-" + etime[6:8] + " " + etime[8:10] + ":" + etime[10:12] + ":00"
        ret.append([chtxtt, title.encode('utf-8'), btime, etime,exp.encode('UTF-8'),longexp.encode('UTF-8'),category.encode('UTF-8')])
    return ret