/*
 * Decompiled with CFR 0.152.
 */
package jtssplitter;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import jtssplitter.calc;
import jtssplitter.data.Descriptor;
import jtssplitter.data.EITData;
import jtssplitter.data.PATData;
import jtssplitter.data.PMTData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mpeg2TSPacket {
    public String header;
    public String payload;
    public String adaptation;
    public byte[] header_byte;
    public byte[] payload_byte;
    public byte[] adaptation_byte;
    public byte[] bPAT_payload = null;
    public int type;
    private int starter;
    private int transporterror;
    private int payloadstart;
    private int transport_priority;
    private int PID = -1;
    private int transport_scrambled;
    private int adaptation_field;
    private int continuity_counter;
    private int adaptation_length;
    private int discontinuity;
    private int random_access;
    private int ES_priority;
    private int five_flag;
    private ArrayList<PATData> pat_list_now = new ArrayList();
    private ArrayList<PATData> pat_list_all = new ArrayList();
    private ArrayList<PMTData> pmt_list = new ArrayList();
    private int pointer_field;
    private String payload_s;
    private int staffing_byte;

    public int getPIDFirst_byte(byte[] ts) {
        calc cal = new calc();
        byte[] b = new byte[]{ts[1], ts[2]};
        return cal.byte2int(b, 3, 13);
    }

    public void readTS_byte(byte[] ts) {
        calc cal = new calc();
        String tsbyte = this.byte2String2(ts);
        boolean begin_payload_unit = cal.byte2int(ts, 9, 1) == 1;
        this.payload = tsbyte.substring(32);
        this.PID = cal.byte2int(ts, 11, 13);
        this.adaptation_field = cal.byte2int(ts, 26, 2);
        this.payload = "";
        if (this.PID != 8191) {
            if (this.adaptation_field == 1) {
                if (begin_payload_unit) {
                    this.pointer_field = cal.byte2int(ts, 32, 8);
                    this.payload_byte = (byte[])(ts.length - 5 - this.pointer_field < 5 + this.pointer_field ? null : cal.byte2subbyte(ts, 5 + this.pointer_field, ts.length - 5 - this.pointer_field));
                } else {
                    this.payload_byte = cal.byte2subbyte(ts, 4, ts.length - 4);
                }
            } else if (this.adaptation_field == 3) {
                this.adaptation_length = cal.byte2int(ts, 32, 8);
                if (this.adaptation_length < 184 & ts.length * 8 - this.adaptation_length * 8 > 48) {
                    this.adaptation_length *= 8;
                }
                this.adaptation_byte = cal.byte2subbyte(ts, 4, 1 + this.adaptation_length / 8);
                if (begin_payload_unit) {
                    this.pointer_field = cal.byte2int(ts, 40 + this.adaptation_length, 8);
                    this.payload_byte = (byte[])(ts.length - 6 - this.adaptation_length / 8 - this.pointer_field < 6 + this.adaptation_length / 8 + this.pointer_field ? null : cal.byte2subbyte(ts, 6 + this.adaptation_length / 8 + this.pointer_field, ts.length - 6 - this.adaptation_length / 8 - this.pointer_field));
                } else {
                    this.payload_byte = cal.byte2subbyte(ts, 5 + this.adaptation_length / 8, ts.length - 5 - this.adaptation_length / 8);
                }
            } else {
                this.payload_byte = null;
            }
        }
        if (this.payload_byte != null) {
            if (this.PID == 0 && begin_payload_unit) {
                this.pat_list_now = this.readPAT_byte(this.payload_byte);
                this.pat_list_all.addAll(this.pat_list_now);
            }
            for (int i = 0; i < this.pat_list_now.size(); ++i) {
                if (this.PID != this.pat_list_now.get((int)i).PID || this.PID == 0) continue;
                this.pmt_list.addAll(this.readPMT_byte(this.payload_byte, this.pat_list_now.get((int)i).Program_TABLE));
            }
        }
        tsbyte = "";
    }

    private ArrayList<PATData> readPAT_byte(byte[] payload_temp) {
        calc cal = new calc();
        ArrayList<PATData> program_number = new ArrayList<PATData>();
        int tableid = cal.byte2int(payload_temp, 0, 8);
        int sectionlength = cal.byte2int(payload_temp, 12, 12);
        int patnum = sectionlength * 8 - 72;
        patnum /= 32;
        for (int i = 0; i < patnum; ++i) {
            if (payload_temp.length * 8 <= 64 + 32 * i + 96 || cal.byte2int(payload_temp, 64 + 32 * i + 16, 3) != 7) continue;
            PATData patd = new PATData();
            patd.Program_TABLE = cal.byte2int(payload_temp, 64 + 32 * i, 16);
            patd.PID = cal.byte2int(payload_temp, 32 * i + 64 + 19, 13);
            program_number.add(patd);
        }
        return program_number;
    }

    private ArrayList<PMTData> readPMT_byte(byte[] payload_temp, int PAT_TABLE) {
        ArrayList<PMTData> pmt_t = new ArrayList<PMTData>();
        calc cal = new calc();
        int tableid = cal.byte2int(payload_temp, 0, 8);
        int section_length = cal.byte2int(payload_temp, 12, 12);
        int pcr_pid = cal.byte2int(payload_temp, 67, 13);
        int program_info_length = cal.byte2int(payload_temp, 84, 12);
        boolean end = false;
        int cur_point = 96 + program_info_length * 8;
        if (cur_point > section_length * 8 - 1 || cur_point > payload_temp.length * 8 - 11) {
            end = true;
        }
        while (!end) {
            if (cal.byte2int(payload_temp, cur_point + 8, 3) == 7 && cal.byte2int(payload_temp, cur_point + 24, 4) == 15 && payload_temp.length * 8 > cur_point + 40) {
                int pmt_stream_type = cal.byte2int(payload_temp, cur_point, 8);
                int elementary_PID = cal.byte2int(payload_temp, cur_point + 11, 13);
                int es_length = cal.byte2int(payload_temp, cur_point + 28, 12);
                PMTData pmtd = new PMTData();
                if (pmt_stream_type == 2 || pmt_stream_type == 15) {
                    pmtd.Stream_Type = pmt_stream_type;
                    pmtd.Program_Table = PAT_TABLE;
                    pmtd.Elementary_PID = elementary_PID;
                    pmtd.PCR_PID = pcr_pid;
                    pmt_t.add(pmtd);
                }
                if ((cur_point = cur_point + 40 + es_length * 8) <= section_length * 8 - 1 && cur_point <= payload_temp.length * 8 - 11) continue;
                end = true;
                continue;
            }
            end = true;
        }
        return pmt_t;
    }

    public ArrayList<EITData> readEIT(byte[] ts) {
        String payload_temp = this.getPayload(ts);
        int tableid = this.TSString2Int(payload_temp, 0, 8);
        int section_length = this.TSString2Int(payload_temp, 12, 12);
        int program_number = this.TSString2Int(payload_temp, 24, 16);
        boolean current_next_indicator = this.TSString2Int(payload_temp, 47, 1) == 1;
        int section_number = this.TSString2Int(payload_temp, 48, 8);
        int curpoint = 112;
        ArrayList<EITData> ret = new ArrayList<EITData>();
        while (curpoint < 24 + section_length * 8 - 32) {
            EITData eitd = new EITData();
            eitd.current_newt_indicator = current_next_indicator;
            eitd.event_id = this.TSString2Int(payload_temp, curpoint, 16);
            eitd.program_number = program_number;
            eitd.section_number = section_number;
            int des_len = this.TSString2Int(payload_temp, curpoint + 84, 12);
            Descriptor des = new Descriptor();
            eitd.descriptors = des.getDescriptors(payload_temp.substring(curpoint + 96, curpoint + 84 + des_len * 8));
            ret.add(eitd);
            curpoint = curpoint + 84 + des_len * 8;
        }
        return ret;
    }

    private int TSString2Int(String s, int begin, int length) {
        String st = s.substring(begin, begin + length);
        int i = Integer.parseInt(st, 2);
        return i;
    }

    public byte[] splitPAT_byte(byte[] ts, int p_table) {
        byte[] tbb = new byte[ts.length - 4];
        System.arraycopy(ts, 4, tbb, 0, tbb.length);
        if (this.bPAT_payload != null && Arrays.equals(tbb, this.bPAT_payload)) {
            byte[] retb = new byte[188];
            System.arraycopy(ts, 0, retb, 0, 4);
            System.arraycopy(this.bPAT_payload, 0, retb, 4, 184);
            return retb;
        }
        calc cal = new calc();
        this.header_byte = cal.byte2subbyte(ts, 0, 4);
        byte[] pointer_byte = cal.byte2subbyte(ts, 4, 1);
        this.payload_byte = cal.byte2subbyte(ts, 4, ts.length - 4);
        this.starter = cal.byte2int(ts, 0, 8);
        boolean begin_payload_unit = cal.byte2int(ts, 9, 1) == 1;
        this.transporterror = cal.byte2int(ts, 8, 1);
        this.payloadstart = cal.byte2int(ts, 9, 1);
        this.transport_priority = cal.byte2int(ts, 10, 1);
        this.PID = cal.byte2int(ts, 11, 13);
        this.adaptation_field = cal.byte2int(ts, 26, 2);
        this.continuity_counter = cal.byte2int(ts, 28, 4);
        if (this.adaptation_field == 1) {
            if (begin_payload_unit) {
                this.pointer_field = cal.byte2int(ts, 32, 8);
                this.payload_byte = (byte[])(ts.length - 5 - this.pointer_field < 5 + this.pointer_field ? null : cal.byte2subbyte(ts, 5 + this.pointer_field, ts.length - 5 - this.pointer_field));
            } else {
                this.payload_byte = cal.byte2subbyte(ts, 4, ts.length - 4);
            }
        } else if (this.adaptation_field == 3) {
            this.adaptation_length = cal.byte2int(ts, 32, 8);
            if (this.adaptation_length < 184 & ts.length * 8 - this.adaptation_length * 8 > 48) {
                this.adaptation_length *= 8;
            }
            this.adaptation_byte = cal.byte2subbyte(ts, 4, 1 + this.adaptation_length / 8);
            if (begin_payload_unit) {
                this.pointer_field = cal.byte2int(ts, 40 + this.adaptation_length, 8);
                this.payload_byte = (byte[])(ts.length - 6 - this.adaptation_length / 8 - this.pointer_field < 6 + this.adaptation_length / 8 + this.pointer_field ? null : cal.byte2subbyte(ts, 6 + this.adaptation_length / 8 + this.pointer_field, ts.length - 6 - this.adaptation_length / 8 - this.pointer_field));
            } else {
                this.payload_byte = cal.byte2subbyte(ts, 5 + this.adaptation_length / 8, ts.length - 5 - this.adaptation_length / 8);
            }
        } else {
            this.payload_byte = null;
        }
        if (this.PID == 0 && begin_payload_unit && this.payload_byte != null) {
            byte[] new_pointer = new byte[]{0};
            this.payload_byte = this.makePAT_byte(new_pointer, this.payload_byte, p_table);
            this.bPAT_payload = this.payload_byte;
        }
        if (this.payload_byte != null && begin_payload_unit) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(ts.length);
            baos.write(this.header_byte, 0, this.header_byte.length);
            baos.write(pointer_byte, 0, pointer_byte.length);
            baos.write(this.payload_byte, 0, this.payload_byte.length);
            for (int ir = 0; ir < 188 - baos.size(); ++ir) {
                baos.write(255);
            }
            return baos.toByteArray();
        }
        return null;
    }

    private byte[] makePAT_byte(byte[] pointer_field, byte[] payload_temp, int Table) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(payload_temp.length);
        calc cal = new calc();
        int sectionlength = cal.byte2int(payload_temp, 12, 12);
        int patnum = sectionlength * 8 - 72;
        baos.write(payload_temp, 0, 1);
        int new_section_length = 17;
        baos.write(cal.joinByte((byte)cal.byte2int(payload_temp, 8, 4), (byte)(new_section_length & 0xF00), 4));
        baos.write((byte)(new_section_length & 0xFF));
        baos.write(payload_temp, 3, 5);
        patnum /= 32;
        int nowt = 8;
        for (int i = 0; i < patnum; ++i) {
            int[] pat = new int[]{cal.byte2int(payload_temp, 64 + 32 * i, 16), cal.byte2int(payload_temp, 32 * i + 64 + 19, 13)};
            if (pat[0] == 0) {
                baos.write(payload_temp, 8 + 4 * i, 4);
                nowt += 4;
                continue;
            }
            if (pat[0] != Table) continue;
            baos.write(payload_temp, 8 + 4 * i, 4);
            nowt += 4;
            i = patnum;
        }
        ByteArrayOutputStream baoscrc = new ByteArrayOutputStream(nowt + 1);
        baoscrc.write(pointer_field[0]);
        baoscrc.write(baos.toByteArray(), 0, baos.size());
        byte[] crc = this.getCRC32_byte(baoscrc.toByteArray(), 1);
        baos.write(crc, 0, crc.length);
        int ill3 = payload_temp.length - baos.size();
        for (int ir = 0; ir < ill3; ++ir) {
            baos.write(255);
        }
        return baos.toByteArray();
    }

    private String getCRC32(String s) {
        return this.getCRC32(this.String2Byte(s), 1);
    }

    private String getCRC32(byte[] data, int offset) {
        int i;
        int[] g = new int[]{1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1};
        int[] shift_reg = new int[32];
        long crc = 0L;
        byte[] crc32 = new byte[4];
        Arrays.fill(shift_reg, 1);
        int nr_bits = (data.length - offset) * 8;
        int bit_in_byte = 0;
        for (int bit_count = 0; bit_count < nr_bits; ++bit_count) {
            int data_bit;
            int n = data_bit = (data[offset] & 128 >>> bit_in_byte++) != 0 ? 1 : 0;
            if ((bit_in_byte &= 7) == 0) {
                ++offset;
            }
            data_bit ^= shift_reg[31];
            for (int i2 = 31; i2 > 0; --i2) {
                shift_reg[i2] = g[i2] == 1 ? shift_reg[i2 - 1] ^ data_bit : shift_reg[i2 - 1];
            }
            shift_reg[0] = data_bit;
        }
        for (i = 0; i < 32; ++i) {
            crc = crc << 1 | (long)shift_reg[31 - i];
        }
        for (i = 0; i < 4; ++i) {
            crc32[i] = (byte)(0xFFL & crc >>> (3 - i) * 8);
        }
        String s = this.Long2String(crc, 32);
        return s;
    }

    private byte[] getCRC32_byte(byte[] data, int offset) {
        int i;
        int[] g = new int[]{1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1};
        int[] shift_reg = new int[32];
        long crc = 0L;
        byte[] crc32 = new byte[4];
        Arrays.fill(shift_reg, 1);
        int nr_bits = (data.length - offset) * 8;
        int bit_in_byte = 0;
        for (int bit_count = 0; bit_count < nr_bits; ++bit_count) {
            int data_bit;
            int n = data_bit = (data[offset] & 128 >>> bit_in_byte++) != 0 ? 1 : 0;
            if ((bit_in_byte &= 7) == 0) {
                ++offset;
            }
            data_bit ^= shift_reg[31];
            for (int i2 = 31; i2 > 0; --i2) {
                shift_reg[i2] = g[i2] == 1 ? shift_reg[i2 - 1] ^ data_bit : shift_reg[i2 - 1];
            }
            shift_reg[0] = data_bit;
        }
        for (i = 0; i < 32; ++i) {
            crc = crc << 1 | (long)shift_reg[31 - i];
        }
        for (i = 0; i < 4; ++i) {
            crc32[i] = (byte)(0xFFL & crc >>> (3 - i) * 8);
        }
        return crc32;
    }

    private String addzero(int num) {
        switch (num) {
            case 0: {
                return "";
            }
            case 1: {
                return "0";
            }
            case 2: {
                return "00";
            }
            case 3: {
                return "000";
            }
            case 4: {
                return "0000";
            }
            case 5: {
                return "00000";
            }
            case 6: {
                return "000000";
            }
            case 7: {
                return "0000000";
            }
            case 8: {
                return "00000000";
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    private String byte2String2(byte[] b) {
        int i;
        int j;
        int bl = b.length;
        bl -= bl % 8;
        bl /= 8;
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < bl; ++i2) {
            long retl = 0L;
            for (j = 0; j < 8; ++j) {
                retl <<= 8;
                int ri = b[i2 * 8 + j] & 0xFF;
                retl += (long)ri;
            }
            sb.append(this.Long2String(retl, 64));
        }
        int bl2 = b.length % 8;
        bl2 = (bl2 - bl2 % 4) / 4;
        for (i = 0; i < bl2; ++i) {
            int reti = 0;
            for (j = 0; j < 4; ++j) {
                reti <<= 8;
                reti += b[bl * 8 + 4 * i + j] & 0xFF;
            }
            sb.append(this.Int2String(reti, 32));
        }
        for (i = 0; i < b.length % 8 % 4; ++i) {
            sb.append(this.Int2String(b[bl * 8 + bl2 * 4 + i] & 0xFF, 8));
        }
        return sb.toString();
    }

    private String Int2String(int num, int length) {
        String ret = Integer.toBinaryString(num);
        if (ret.length() < length) {
            int it = length - ret.length();
            for (int i = 0; i < it; ++i) {
                ret = "0" + ret;
            }
        }
        return ret;
    }

    private String Long2String(long num, int length) {
        String ret = Long.toBinaryString(num);
        if (ret.length() < length) {
            int it = length - ret.length();
            for (int i = 0; i < it; ++i) {
                ret = "0" + ret;
            }
        }
        return ret;
    }

    private byte[] String2Byte(String ts) {
        int len = ts.length() - ts.length() % 8;
        byte[] ret = new byte[len /= 8];
        for (int i = 0; i < len; ++i) {
            String tet = ts.substring(i * 8, i * 8 + 8);
            int itt = this.TSString2Int(tet, 0, 8);
            ret[i] = (byte)itt;
        }
        return ret;
    }

    public ArrayList<PATData> getPAT() {
        return this.pat_list_all;
    }

    public void setPAT(ArrayList pat) {
        this.pat_list_now = pat;
        this.pat_list_all = pat;
    }

    public ArrayList<PMTData> getPMT() {
        return this.pmt_list;
    }

    public void setPMT(ArrayList pmt) {
        this.pmt_list = pmt;
    }

    public int getPID() {
        return this.PID;
    }

    public String getPayload(byte[] ts) {
        String tsbyte = this.byte2String2(ts);
        String ret_payload = "";
        int pid = this.TSString2Int(tsbyte, 11, 13);
        int af = this.TSString2Int(tsbyte, 26, 2);
        if (pid != 8191) {
            if (af == 1) {
                ret_payload = tsbyte.substring(40);
            } else if (af == 3) {
                int al = this.TSString2Int(tsbyte, 32, 8);
                if (al < 184 & tsbyte.length() - al * 8 > 48) {
                    al *= 8;
                }
                ret_payload = tsbyte.substring(48 + al);
            }
        }
        return ret_payload;
    }

    public byte[] getPayload_byte(byte[] ts) {
        calc cal = new calc();
        String tsbyte = this.byte2String2(ts);
        byte[] retb = null;
        int pid = cal.byte2int(ts, 11, 13);
        int af = cal.byte2int(ts, 26, 2);
        if (pid != 8191) {
            if (af == 1) {
                retb = cal.byte2subbyte(ts, 5, ts.length - 5);
            } else if (af == 3) {
                int al = cal.byte2int(ts, 32, 8);
                if (al < 184 & ts.length * 8 - al * 8 > 48) {
                    al *= 8;
                }
                retb = cal.byte2subbyte(ts, 6 + al / 8, ts.length - 6 - al / 8);
            }
        }
        return retb;
    }

    public ArrayList<PMTData> readPMTglobal_byte(byte[] ts, int TABLE_NUM) {
        byte[] payloadt = this.getPayload_byte(ts);
        return this.readPMT_byte(payloadt, TABLE_NUM);
    }

    public void showPAT(String ts) {
        System.out.println("\u5148\u982d:" + ts.substring(0, 8));
        System.out.println("" + ts.substring(8, 11));
        System.out.println("PID:" + ts.substring(11, 24));
        System.out.println("" + ts.substring(24, 32));
        System.out.println("Adap_Len:" + ts.substring(32, 40));
        System.out.println("TableID:" + ts.substring(40, 48));
        System.out.println("" + ts.substring(48, 52));
        System.out.println("len : " + ts.substring(52, 64) + "//" + Integer.toString(Integer.parseInt(ts.substring(52, 64), 2)));
        System.out.println("TS ID:" + ts.substring(64, 80));
        System.out.println("11:" + ts.substring(80, 82));
        System.out.println("" + ts.substring(82, 104));
        for (int i = 0; i < 10; ++i) {
            System.out.println(Integer.toString(i) + " : " + ts.substring(104 + 32 * i, 136 + 32 * i));
        }
        System.out.println("Length:" + Integer.toString(ts.length()));
    }
}

