/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 *
 * RBTOS ̃Xbh؊Ȃǂ̃AZuR[h
 * $Id: rbtos_asm.S 29 2012-11-17 18:28:25Z xeerda $
 *****************************************************************************/
#include <p32xxxx.h>
#include <sys/asm.h>
#include "rbtos_asm.inc"


/*****************************************************************************
 * unsigned long Get_GP(void)
 *****************************************************************************/
	.set	nomips16
	.set	noreorder
	.extern Get_GP
	.ent	Get_GP
Get_GP:
	J		ra
	move	v0, gp
	.end	Get_GP


/*****************************************************************************
 * ^XNXCb`
 * void RBTOS_Thread_switch(RBTOS_ThreadT *next)
 * ݎs̃^XN(pCurThread) ̃^XNReLXgۑC
 * ɃANeBuɂȂ^XN(next) ̃^XNReLXg𕜋A܂.
 * ̊֐ĂԑOɁC^XNXg^XN؊̏ԂɂĂ܂.
 *****************************************************************************/
	.set	nomips16
	.set	noat
 	.set 	noreorder
	.extern CoreSoftwareInt0Handler
	.ent	CoreSoftwareInt0Handler

CoreSoftwareInt0Handler:
	mfc0	k0, _CP0_CAUSE
	mfc0	k1, _CP0_EPC
	srl	k0, k0, 0xa
	addiu	sp, sp, -128
	sw	k1, 40(sp)		// @(sp + 40) ... EPC
	mfc0	k1, _CP0_STATUS
	sw	k1, 44(sp)		// @(sp + 44) ... STATUS
	
	ins	k1, k0, 10, 6		// CP0_SETATUS  IPL<2:0> ɁCCP0_CAUSE  RIPL<2:0> Rs[
	//ins	k1, zero, 1, 4		// UM, ERL, EXL  0
	ins	k1, zero, 0, 5		// UM, ERL, EXL, EI  0
	mtc0	k1, _CP0_STATUS		// ܂֎~Ȃ
	
	// Caller save WX^̕ۑ
	sw	a0, 48(sp)
	sw	a1, 52(sp)
	sw	a2, 56(sp)
	sw	a3, 60(sp)
	sw	v0, 64(sp)
	sw	v1, 68(sp)
	sw	t0, 72(sp)
	sw	t1, 76(sp)
	sw	t2, 80(sp)
	sw	t3, 84(sp)
	sw	t4, 88(sp)
	sw	t5, 92(sp)
	sw	t6, 96(sp)
	sw	t7, 100(sp)
	sw	t8, 104(sp)
	sw	t9, 108(sp)
	sw	$ra, 112(sp)
	sw	$at, 116(sp)
	
	mfhi	a0
	mflo	a1
	sw	a0, 120(sp)
	sw	a1, 124(sp)

	
	mfc0	a0, _CP0_CAUSE
	ins	a0, zero, 8, 1
	mtc0	a0, _CP0_CAUSE

	la	a0, IFS0CLR
	la	a1, 0x02
	sw	a1, 0(a0)

	
	// lsActiveThread == pCurThread ??
	la	a0, lsActvThreads
	la	a1, pCurThread
	lw	a2, 0(a0)
	lw	a3, 0(a1)
	
	bne	a2, a3, ThreadSwitch000
	nop
	
	// Caller Save WX^̕A
	lw	a0, 120(sp)
	lw	a1, 124(sp)
	mthi	a0
	mtlo	a1
	
	lw	a0, 48(sp)
	lw	a1, 52(sp)
	lw	a2, 56(sp)
	lw	a3, 60(sp)
	lw	v0, 64(sp)
	lw	v1, 68(sp)
	lw	t0, 72(sp)
	lw	t1, 76(sp)
	lw	t2, 80(sp)
	lw	t3, 84(sp)
	lw	t4, 88(sp)
	lw	t5, 92(sp)
	lw	t6, 96(sp)
	lw	t7, 100(sp)
	lw	t8, 104(sp)
	lw	t9, 108(sp)
	lw	$ra, 112(sp)
	lw	$at, 116(sp)
	
	di
	lw	k0, 40(sp)
	lw	k1, 44(sp)
	
	addiu	sp, sp, 128
	mtc0	k0, _CP0_EPC
	mtc0	k1, _CP0_STATUS
	eret
	
ThreadSwitch000:
	// Callee Save WX^̕ۑ
	sw	s0, 0(sp)
	sw	s1, 4(sp)
	sw	s2, 8(sp)
	sw	s3, 12(sp)
	sw	s4, 16(sp)
	sw	s5, 20(sp)
	sw	s6, 24(sp)
	sw	s7, 28(sp)
	sw	s8, 32(sp)
	sw	gp, 36(sp)
	
	di
	sw	sp, 0(a3)		// pCurThread->pLastSP  sp
	sw	a2, 0(a1)		// pCurThread  lsActvThreads
	
	lw	sp, 0(a2)		// sp  lsActvThreads->pLastSP
	
	lw	s0, 0(sp)
	lw	s1, 4(sp)
	lw	s2, 8(sp)
	lw	s3, 12(sp)
	lw	s4, 16(sp)
	lw	s5, 20(sp)
	lw	s6, 24(sp)
	lw	s7, 28(sp)
	lw	s8, 32(sp)
	lw	gp, 36(sp)
	
	lw	a0, 120(sp)
	lw	a1, 124(sp)
	mthi	a0
	mtlo	a1
	
	lw	a0, 48(sp)
	lw	a1, 52(sp)
	lw	a2, 56(sp)
	lw	a3, 60(sp)
	lw	v0, 64(sp)
	lw	v1, 68(sp)
	lw	t0, 72(sp)
	lw	t1, 76(sp)
	lw	t2, 80(sp)
	lw	t3, 84(sp)
	lw	t4, 88(sp)
	lw	t5, 92(sp)
	lw	t6, 96(sp)
	lw	t7, 100(sp)
	lw	t8, 104(sp)
	lw	t9, 108(sp)
	lw	$ra, 112(sp)
	lw	$at, 116(sp)
	
	lw	k0, 40(sp)
	lw	k1, 44(sp)
	
	addiu	sp, sp, 128
	mtc0	k0, _CP0_EPC
	mtc0	k1, _CP0_STATUS
	eret
	.end	CoreSoftwareInt0Handler


/*****************************************************************************
 * ֎~.
 * <p>
 * unsigned long RBTOS_disable(void)
 * CPU x 2 ȉ̊֎~܂.
 * @return
 *   ̊֐ĂяoO CPU Xe[^XWX^lԋp܂.
 *   Ȃ̖͂߂lɁCRBTOS_set_imask() ֐R[邱ƂŁC
 *   ̊֐̌ĂяoȌԂɖ߂Ƃł܂.
 *****************************************************************************/
	.set	nomips16
 	.set 	noreorder
	.extern RBTOS_disable
	.ent	RBTOS_disable
RBTOS_disable:
	di
	J	$ra
	nop
	.end	RBTOS_disable


/*****************************************************************************
 * CPU Xe[^XWX^ݒ.
 * 
 * RBTOS_set_imask(unsigned long value)
 * @param value CPU Xe[^XWX^̐ݒl.
 *****************************************************************************/
	.set	nomips16
 	.set 	noreorder
	.extern RBTOS_enable
	.ent	RBTOS_enable
RBTOS_enable:
	ei
	j	$ra
	nop
	.end	RBTOS_enable


/*****************************************************************************
 * ^C} 3
 *****************************************************************************/
	.set	nomips16
 	.set 	noreorder
	.extern Timer3HandlerWrapper
	.extern	Timer3Handler
	.ent	Timer3HandlerWrapper
	
Timer3HandlerWrapper:
	RBTOS_PREV_INTERRUPT
	
	addu	s8, sp, zero
	jal	Timer3Handler
	nop
	addu	sp, s8, zero
	
	RBTOS_AFTER_INTERRUPT
	
	.end 	Timer3HandlerWrapper


/*****************************************************************************
 * iRBTOS_end_interrupt
 *****************************************************************************/
	.set	nomips16
 	.set 	noreorder
	.extern iRBTOS_end_interrupt
	.ent	iRBTOS_end_interrupt
iRBTOS_end_interrupt:
	lw	a0, 44(sp)
	la	a1, 0x0000FC00
	and	a0, a0, a1
	bne	a0, zero, NoThreadSwitch
	nop
	
	la	a0, lsActvThreads
	la	a1, pCurThread
	lw	a2, 0(a0)
	lw	a3, 0(a1)
	
	bne	a2, a3, ThreadSwitch000I
	nop

// Xbh؂芷I
NoThreadSwitch:
	lw	a0, 120(sp)
	lw	a1, 124(sp)
	mthi	a0
	mtlo	a1
	
	lw	a0, 48(sp)
	lw	a1, 52(sp)
	lw	a2, 56(sp)
	lw	a3, 60(sp)
	lw	v0, 64(sp)
	lw	v1, 68(sp)
	lw	t0, 72(sp)
	lw	t1, 76(sp)
	lw	t2, 80(sp)
	lw	t3, 84(sp)
	lw	t4, 88(sp)
	lw	t5, 92(sp)
	lw	t6, 96(sp)
	lw	t7, 100(sp)
	lw	t8, 104(sp)
	lw	t9, 108(sp)
	lw	$ra, 112(sp)
	lw	$at, 116(sp)
	
	di
	lw	k0, 40(sp)
	lw	k1, 44(sp)
	
	addiu	sp, sp, 128
	mtc0	k0, _CP0_EPC
	mtc0	k1, _CP0_STATUS
	eret
//---
ThreadSwitch000I:
	// Callee Save WX^̕ۑ
	sw	s0, 0(sp)
	sw	s1, 4(sp)
	sw	s2, 8(sp)
	sw	s3, 12(sp)
	sw	s4, 16(sp)
	sw	s5, 20(sp)
	sw	s6, 24(sp)
	sw	s7, 28(sp)
	sw	s8, 32(sp)
	sw	gp, 36(sp)
	
	di
	sw	sp, 0(a3)		// pCurThread->pLastSP  sp
	sw	a2, 0(a1)		// pCurThread  lsActvThreads
	
	lw	sp, 0(a2)		// sp  lsActvThreads->pLastSP
	
	lw	s0, 0(sp)
	lw	s1, 4(sp)
	lw	s2, 8(sp)
	lw	s3, 12(sp)
	lw	s4, 16(sp)
	lw	s5, 20(sp)
	lw	s6, 24(sp)
	lw	s7, 28(sp)
	lw	s8, 32(sp)
	lw	gp, 36(sp)
	
	lw	a0, 120(sp)
	lw	a1, 124(sp)
	mthi	a0
	mtlo	a1
	
	lw	a0, 48(sp)
	lw	a1, 52(sp)
	lw	a2, 56(sp)
	lw	a3, 60(sp)
	lw	v0, 64(sp)
	lw	v1, 68(sp)
	lw	t0, 72(sp)
	lw	t1, 76(sp)
	lw	t2, 80(sp)
	lw	t3, 84(sp)
	lw	t4, 88(sp)
	lw	t5, 92(sp)
	lw	t6, 96(sp)
	lw	t7, 100(sp)
	lw	t8, 104(sp)
	lw	t9, 108(sp)
	lw	$ra, 112(sp)
	lw	$at, 116(sp)
	
	lw	k0, 40(sp)
	lw	k1, 44(sp)
	
	addiu	sp, sp, 128
	mtc0	k0, _CP0_EPC
	mtc0	k1, _CP0_STATUS
	eret
	.end	iRBTOS_end_interrupt



        .set    nomips16
        .set    noreorder
        .extern RBTOS_IssueSoftInt0
        .ent    RBTOS_IssueSoftInt0
RBTOS_IssueSoftInt0:
        mfc0    v0, _CP0_CAUSE         // Cause |= 0x100
        ori     v0, v0, 0x100          //  :
        mtc0    v0, _CP0_CAUSE         //  :
        j       ra                     // 
        nop                            //
        .end    RBTOS_IssueSoftInt0


