/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 *
 * RBTOS jR[h
 * $Id: rbtos.h 28 2012-11-17 15:09:43Z xeerda $
 *****************************************************************************/
#ifndef __RBTOS_H__
#define __RBTOS_H__

#include "RBTOS_config.h"
#include <stddef.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#ifdef	__cplusplus
extern "C"
{
#endif	/* __cplusplus */

typedef unsigned short RBTOS_WCHAR_T;

/**
 * @mainpage
 *
 * yʃA^CIy[eBOVXe
 */
/**
 * @defgroup RBTOS
 */


/**
 * @defgroup CONFIG JX^}CY
 * @ingroup RBTOS
 */
/**
 * @addtogroup CONFIG
 */
/* @{ */

#ifndef RBTOS_CONF_MAIN_PRIORITY
/**
 * Main Xbh̗Dx.
 * <p>
 * RBTOS ̃Xbh́C0 ~ 254 ܂ł̗Dx܂.<br>
 * XbhDx́CXbhɎw肷邱Ƃł܂.<br>
 * CMain Xbĥ݂́C{}N`Ŏw肵DxƂȂ܂.<br>
 * <p>
 * Main Xbh́COS Ƃ (::RBTOS_initialize() R[Ƃ)C
 * ŏɐXbhł.<br>
 * ::RBTOS_initialize() 烊^[ƂC̎_ŃvOsĂ̂C
 * Main Xbhł.<br>
 * <p>
 * ʏCRBTOS_config.h  RBTOS_CONF_MAIN_PRIORITY `܂.<br>
 * RBTOS_CONF_MAIN_PRIORITY `̏ꍇCȉ̒lɏ܂.
 */
  #define RBTOS_CONF_MAIN_PRIORITY		(10)
#endif /* RBTOS_CONF_MAIN_PRIORITY */

/* @} */


/**
 * @defgroup THREAD XbhǗ
 * @ingroup RBTOS
 */
/**
 * @addtogroup THREAD
 * RBTOS ́C}`Xbh̃A^CIy[eBOVXeł.<br>
 * RBTOS 𗘗pvÓC̎sɂẴC
 * ɃXbh𐶐Cs邱Ƃł܂.<br>
 * <p>
 * CPU ǂ̃Xbhs邩́CD揇ʂɂČɌ肵܂.<br>
 * CPU ́CɁus\ȃXbhv̂CułD揇ʂ̍Xbhvs܂.<br>
 * D揇ʂ̒ႢXbh́C荂XbĥׂĂCX[vC܂̓Cxg҂C
 * ܂̓bN҂ɂȂ܂Ŏs܂.
 * <p>
 * Xbh́C ::RBTOS_initialize sɐ Main XbhƁC
 * RBTOS_Thread_create:: ɂĐXbh܂.<br>
 * @{ */

/**
 * XbhReLXg\.
 * <p>
 * fobOprāC{I OS ÓC̃oANZXȂł.
 */
typedef struct RBTOS_ThreadT {
	/** ^XN񊈐̃X^bN|C^ʒu. */
	void *pLastSP;
	/** X^bNI[o[t[`FbNpWX^ SPLIM ɐݒ肷l. */
	void *pStackLimit;
	/** ^XNDx. */
	unsigned char bPriority;
	/** Cxg^CAEgtO. */
	unsigned char fIsTimedOut;
	/** XbhXg\̎vf. */
	struct RBTOS_ThreadT *pLstNext;
	/** bN^Cxg҂ł̃Xg\̎vf. */
	struct RBTOS_ThreadT *pObjNext;
	/** Ԍo߂ɂXbhA܂ł̃eBbNJEg. */
	unsigned long dwSleepTick;
	/** 擾҂̃Cxg. */
	struct RBTOS_EventT *pEvent;
	/** Xbh. */
	const char *strName;
	/** X^bN̈. */
	RBTOS_STACK_ELEM_T *pStack;
	/** X^bN̈̏I[. */
	RBTOS_STACK_ELEM_T *pStackEnd;
} RBTOS_ThreadT;

/**
 * Xbh̐.
 * <p>
 * Xbh𐶐ĊJn܂.<br>
 * Xbh̗DxCJgXbh荂ꍇC
 * Xbh͑ɃXbhsl܂.<br>
 * łȂꍇCXbh́Csҋ@Xg̗DxɑΉʒuɂȂ܂.<br>
 * i̗Dx̃Xbh݂ꍇC̗Dx̃Xbh̍ŌɂȂ܂.)<br>
 * <p>
 *  API ́CXbhReLXgCԂŃR[Ă.<br>
 * 
 * @param pnew
 *   Xbh̃XbhReLXĝ߂̃̈w肵܂.<br>
 *   ̈̃TCYsizeof(RBTOS ThreadT)Kvł.<br>
 *   ̈̓e͕sł܂܂.<br>
 *   ̃̈́CXbhI܂ RBTOS ̊Ǘɒu܂̂ŁCύXĂ͂܂.
 * @param func
 *   XbhŎs֐w肵܂.<br>
 *   Xbh́C̊֐^[ƏI܂.
 * @param arg
 *   Xbhs֐ɓnw肵܂.
 * @param pri
 *   XbhDxw肵܂.<br>
 *   w\Ȓl͈̔͂ 0 ` 254 ł.<br>
 *   ȊO̒lw肵ꍇ͕̓sł.<br>
 *   lقǗD揇ʂ͍Ȃ܂.
 * @param stack
 *   Xbh̃X^bN̂߂̃̈w肵܂.<br>
 *   stack ̃AhX́C ::RBTOS_STACK_ELEM_T ̃TCY̋EɔzuĂȂ΂Ȃ܂.<br>
 *   ̃̈́CXbhI܂ RBTOS ̊Ǘɒu܂̂ŁCύXĂ͂܂.
 * @param stacksize
 *   X^bN̈̃oCgw肵܂.<br>
 *   ::RBTOS_STACK_ELEM_T ̃TCY̔{łȂ΂Ȃ܂.
 * @param threadname
 *   Xbhw肵܂.<br>
 *   ̃|C^́CXbhI܂őȂ΂Ȃ܂.
 * @return
 *   Xbh̃XbhReLXgւ̃|C^ԋp܂.<br>
 *   pnewƓlł.
 */
RBTOS_ThreadT *RBTOS_Thread_create(RBTOS_ThreadT *pnew, void (*func)(void *),
								   void *arg, unsigned char pri,
								   void *stack, size_t stacksize,
								   const char *threadname);

/**
 * Xbh̎s~.
 * <p>
 * JgXbhweBbNԁCx~܂.<br>
 * weBbNԁiticks j 0 ɂꍇCXbhs̈Ϗ݂̂s܂.<br>
 * łȂCeBbNԂ0ȊOw肵ꍇCJgXbh͋x~ԂɑJڂ܂.<br>
 * x~ԂɑJڂXbh́ČCweBbŇo߂ɂāCsԁC܂͎sҋ@
 * ԂɑJڂ܂.
 * <p>
 *  API ́CXbhReLXgCԂŃR[Ă.<br>
 * @param ticks 
 *   x~ԂeBbNlŎw肵܂.
 *   w\Ȑl͈̔͂́C0`0xFFFFFFFFUL ł.
 */
void RBTOS_Thread_sleep(unsigned long ticks);

/* @} */


/**
 * @defgroup EVENT Cxg
 * @ingroup RBTOS
 */
/**
 * @addtogroup EVENT
 */
/* @{ */

/** Cxg\. */
typedef struct RBTOS_EventT {
	/** Cxg̊l҂ĂXbhQێ郊Xg. */
	RBTOS_ThreadT *pWaitingList;
	/** CxgVOiԂɂ邩ۂ. */
	unsigned char fSignaled;
} RBTOS_EventT;


/**
 * Cxg\̂萔.
 * <p>
 * Cxg\̌^̕ϐ`ɁCȉ̂悤ɋLqƁC RBTOS_Event_create() ̌Ăяoȗł܂.
 *
 * <pre><code>RBTOS_Event_T evtHoge = RBTOS_INITIALIZED_EVENT_VALIE;</code></pre>
 */
#define RBTOS_INITIALIZED_EVENT_VALUE	{ NULL, 0 }


/**
 * Cxg̐.
 * @param pNewEvent Cxg\̂ւ̃|C^.
 */
static inline void RBTOS_Event_create(RBTOS_EventT *pNewEvent)
{
	pNewEvent->fSignaled = 0;
	pNewEvent->pWaitingList = NULL;
}

/**
 * Cxg҂.
 * @param pevent Cxg\̂ւ̃|C^.
 * @param ticks Cxg҂^CAEg̃eBbNl.
 *        0 ̏ꍇCԖŃCxg҂܂.
 * @return
 *    ^CAEgɂ胊^[ꍇ 1 ԋp܂.
 *    łȂCCxgʒmɂ胊^[ꍇ 0 ԋp܂.
 */
int RBTOS_Event_wait(RBTOS_EventT *pevent, unsigned long ticks);

/**
 * ̃Cxgʒm.
 * @param pevent Cxg\̂ւ̃|C^.
 * @return
 *    CxgʒmɂCÃXbh؂ւꍇC
 *    IɎs𓾂Xbh\̂ւ̃|C^ԋp܂.
 *    łȂCXbh؂ւȂꍇ NULL ԋp܂.
 */
void iRBTOS_Event_set(RBTOS_EventT *pevent);

/**
 * Cxgʒm.
 * w̃Cxg҂Ă邷ׂẴXbhɃCxgʒm܂.
 * @param pevent Cxg\̂ւ̃|C^.
 */
void RBTOS_Event_set(RBTOS_EventT *pevent);


/* @} */


/**
 * @defgroup LOCK bN
 * @ingroup RBTOS
 */
/**
 * @addtogroup LOCK
 */
/* @{ */



/** bN\ */
typedef struct RBTOS_LockT {
	/** bN̏L. bNĂȂƂ NULL */
	RBTOS_ThreadT *owner;
	/** bN̊l҂ĂXbhQێ郊Xg. */
	RBTOS_ThreadT *pWaitingList;
	/** dbÑJEg. */
	unsigned char bCount;
} RBTOS_LockT;

#define RBTOS_INITIALIZED_LOCK_VALUE { NULL, NULL, 0 }

/* @} */



/**
 * @defgroup API ֐t@X
 * @ingroup RBTOS
 */

/**
 * @addtogroup API
 */

/* @{ */

/**
 * ֎~.
 * <p>
 * CPU x 1 ̊֎~܂.
 * @return
 *   ̊֐ĂяoO CPU Xe[^XWX^lԋp܂.
 *   Ȃ̖͂߂lɁCRBTOS_set_imask() ֐R[邱ƂŁC
 *   ̊֐̌ĂяoȌԂɖ߂Ƃł܂.
 */
static inline RBTOS_CCR_ELEM_T RBTOS_disable(void)
{
	unsigned short prevSR = SR;
	SR = 0xE0;
	return prevSR;
}

/**
 * CPU Xe[^XWX^ݒ.
 * <p>
 * @param value CPU Xe[^XWX^̐ݒl.
 */
static inline void RBTOS_set_imask(unsigned value)
{
	SR = value;
}


/**
 * OS .
 */
void RBTOS_initialize(void);



/**
 * bN̐.
 * @param pNewLock 郍bN\̂ւ̃|C^.
 */
static inline void RBTOS_Lock_create(RBTOS_LockT *pNewLock)
{
	pNewLock->pWaitingList = NULL;
	pNewLock->owner = NULL;
	pNewLock->bCount = 0;
}

/**
 * bN̎擾.
 * <p>
 * bN̎擾݂܂.
 * łɑ̃XbhbN擾ĂꍇC
 * ҂Xg̍ŌɎXbhǉ܂.
 * āCbN擾ł܂Ŏ^XN̎s~܂.
 * łȂCbN擾ĂXbh݂ȂꍇC
 * bN擾CɃ^[܂.
 * ܂CXbhłłɃbN擾ĂꍇCdbNƂȂ܂.
 * ̏ꍇCbNJEgCNgCɃ^[܂.
 * dbNꍇCbN̉ɂ́C
 * RBTOS_Lock_leave() 𑽏dbN񐔉sKv܂.
 * @param lock bN\̂ւ̃|C^.
 */
void RBTOS_Lock_enter(RBTOS_LockT *lock);

/**
 * bN̉.
 * @param lock bN\̂ւ̃|C^.
 * bNJEgfBNg܂.
 * bNJEg 0 ̏ꍇCbN̏L܂.
 */
void RBTOS_Lock_leave(RBTOS_LockT *lock);


unsigned long getCurTick(void);

/* @} */

#ifdef	__cplusplus
}
#endif	/* __cplusplus */

#endif /* __RBTOS_H__ */
