/*****************************************************************************
 *    Licensed to the Apache Software Foundation (ASF) under one
 *    or more contributor license agreements.  See the NOTICE file
 *    distributed with this work for additional information
 *    regarding copyright ownership.  The ASF licenses this file
 *    to you under the Apache License, Version 2.0 (the
 *    "License"); you may not use this file except in compliance
 *    with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing,
 *    software distributed under the License is distributed on an
 *    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *    KIND, either express or implied.  See the License for the
 *    specific language governing permissions and limitations
 *    under the License.
 *
 * RBTOS jR[h
 * $Id: rbtos.c 29 2012-11-17 18:28:25Z xeerda $
 *****************************************************************************/
#include "rbtos.h"
#if (RBTOS_CONF_HAVE_DEVICE != 0)
  #include "rbtDevice.h"
  #include "rbtUART.h"
#endif /* RBTOS_CONF_HAVE_DEVICE */

// JgXbh
RBTOS_ThreadT *pCurThread;

// s\XbhXg
RBTOS_ThreadT *lsActvThreads;

// ҋ@ԂŁCԌo߂ŕAXbhXg
static RBTOS_ThreadT *lsTmWaitThreads;

// ݂̃eBbNl
static unsigned long RBTOS_dwCurTick;
// dwNextWkupTick ݒ肵Ƃ̃eBbNl
static unsigned long dwPrevTick;


// Main Xbh
static RBTOS_ThreadT MainThread;

// AChXbh
static RBTOS_ThreadT IdleThread;

// AChXbh̃X^bN̈
static RBTOS_STACK_ELEM_T IdleStack[128];

static void xAddToActiveThreadList(RBTOS_ThreadT *pTask);
static void xIdleThreadFunc(void *arg);
static void xThreadEntry(void *arg, void (*funcThread)(void *arg));
static void xThreadDestroy(void);


void RBTOS_Thread_switch(void);

void *RBTOS_get_main_splim(void);

/*****************************************************************************
 * ֐
 *****************************************************************************/
void RBTOS_initialize(void)
{
	// Timer1 C1ms Ɋ悤ݒ.
	PR1 = 2000;					// 0.5us x 2000 = 1ms
	T1CON = 0b1000000000010000; // Tick = 1/16MHz * 8 = 0.5us
	IEC0bits.T1IE = 1;			// L
	IPC0bits.T1IP = 1;			// Dx = 1 (OS Ǘ̊)
	
	// Main Xbh̐ݒ
	memset(&MainThread, 0, sizeof(RBTOS_ThreadT));
	MainThread.bPriority = RBTOS_CONF_MAIN_PRIORITY;
	MainThread.pStackLimit = RBTOS_get_main_splim();
	MainThread.strName = "MAIN";
	lsActvThreads = &MainThread;
	pCurThread = &MainThread;
	
	RBTOS_Thread_create(&IdleThread, xIdleThreadFunc, 0, 255, 
						IdleStack, sizeof(IdleStack),
						"IDLE");
}

/*****************************************************************************
 * ^C} 1  (XbhXPW[)
 *****************************************************************************/
void T1InterruptFunc(void)
{
	unsigned long cur_tick;
	unsigned long passing_ticks;
	RBTOS_ThreadT **pp;
	RBTOS_ThreadT *p;
	
	IFS0bits.T1IF = 0;
	cur_tick = RBTOS_dwCurTick = RBTOS_dwCurTick + 1;
	LATBbits.LATB15 = ((RBTOS_dwCurTick & 0x200) != 0); // LED _
	
	if (lsTmWaitThreads == NULL) {
		return; // Ԍo߂ŊXbh͖
	}
	
	passing_ticks = cur_tick - dwPrevTick;
	if (lsTmWaitThreads->dwSleepTick > passing_ticks) {
		return; // ͂莞Ԍo߂ŊXbh͖
	}
	
	pp = &lsTmWaitThreads;
	while ((p = *pp) != NULL) {
		RBTOS_EventT *evt;
		if (p->dwSleepTick > passing_ticks) {
			break;
		}
		
		// ̃Xbh (p) ͍Ŋ.
		// Ȃ̂ŁCANeBuXgɒǉ.
		*pp = p->pLstNext;
		xAddToActiveThreadList(p);
		
		evt = p->pEvent;
		if (evt != NULL) {
			// ̃XbhCxg҂ԂȂCCxg҂LZ.
			RBTOS_ThreadT **qq;
			for (qq = &evt->pWaitingList; *qq != NULL; qq = &(*qq)->pObjNext) {
				if (*qq == p) {
					*qq = p->pObjNext;
					break;
				}
			}
			p->pObjNext = NULL;
			p->pEvent = NULL;
		}
	}
	
	while ((p = *pp) != NULL) {
		// ̃Xbh (p) ́C͊Ȃ.
		p->dwSleepTick -= passing_ticks;
		pp = &p->pLstNext;
	}
	dwPrevTick = cur_tick;
}

/*****************************************************************************
 * ʕb擾
 * `[ibv̒ZԂ̏̑xprz肵Ă܂.
 *  ^C~OɂĂ͕smȒlԂƂ܂.
 *****************************************************************************/
unsigned long getTickUs(void)
{
	IEC0bits.T1IE = 0;										// 
	unsigned long tick = RBTOS_dwCurTick * 1000 + (TMR1 >> 1);
	IEC0bits.T1IE = 1;										// L
	return tick;
}

unsigned long getCurTick(void)
{
	IEC0bits.T1IE = 0;										// 
	unsigned long tick = RBTOS_dwCurTick;
	IEC0bits.T1IE = 1;										// L
	return tick;
}


/*****************************************************************************
 * Xbh̍쐬ƊJn
 *****************************************************************************/
RBTOS_ThreadT *RBTOS_Thread_create(RBTOS_ThreadT *pnew,
								   void (*func)(void *),
								   void *arg, unsigned char pri,
								   void *stack, size_t stacksize,
								   const char *threadname)
{
	RBTOS_CCR_ELEM_T ccr;
	RBTOS_STACK_ELEM_T *p;
	
	RBTOS_assert(pnew != NULL);
	
	stacksize = stacksize & ~(sizeof(RBTOS_STACK_ELEM_T) - 1);
	RBTOS_assert((stack != NULL) && (stacksize >= 256));
	
	memset(pnew, 0, sizeof(RBTOS_ThreadT));
	pnew->bPriority = pri;
	pnew->strName = threadname;
	pnew->pStack = (RBTOS_STACK_ELEM_T*) stack;
	pnew->pStackEnd = (RBTOS_STACK_ELEM_T*) ((unsigned char*) stack + stacksize);
	
	p = pnew->pStack + 1;
	
	pnew->pStackLimit = pnew->pStackEnd - 2; // SPLIM
	pnew->pLastSP = p + 22;
	p[0] = (RBTOS_STACK_ELEM_T) xThreadEntry;	// PC<15:0>
	p[1] = 0;									// SRL, PC<22:16>
	p[2] = 0x00E0;								// SR
	p[3] = (RBTOS_STACK_ELEM_T) arg;			// W0
	p[4] = (RBTOS_STACK_ELEM_T) func;			// W1
	//p[5] = 0x0202;							// W2
	//p[6] = 0x0303;							// W3
	//p[7] = 0x0404;							// W4
	//p[8] = 0x0505;							// W5
	//p[9] = 0x0606;							// W6
	//p[10] = 0x0707;							// W7
	p[11] = 0;									// RCOUNT
	p[12] = TBLPAG;								//
	p[13] = CORCON;								//
	p[14] = PSVPAG;								//
	//p[15] = 0x0808;							// W8
	//p[16] = 0x0909;							// W9
	//p[17] = 0x1010;							// W10
	//p[18] = 0x1111;							// W11
	//p[19] = 0x1212;							// W12
	//p[20] = 0x1313;							// W13
	//p[21] = 0x1414;							// W14
	ccr = RBTOS_disable();
	xAddToActiveThreadList(pnew);
	
	if (pri < pCurThread->bPriority) {
		RBTOS_Thread_switch();
	}
	RBTOS_set_imask(ccr);
	return pnew;
}


/*****************************************************************************
 * X[v
 * dwMillis = 0 ͎s̈ڏ.
 *****************************************************************************/
void RBTOS_Thread_sleep(unsigned long ticks)
{
	RBTOS_ThreadT *cur;
	RBTOS_ThreadT *next;
	RBTOS_CCR_ELEM_T ccr = RBTOS_disable();
	cur = pCurThread;
	next = cur->pLstNext;
	RBTOS_assert(cur == lsActvThreads);
	RBTOS_assert(cur->pEvent == NULL);
	if (ticks == 0) {
		if (next != NULL) {
			lsActvThreads = next;
			xAddToActiveThreadList(cur);
			RBTOS_Thread_switch();
		}
	} else {
		RBTOS_ThreadT **pp;
		RBTOS_ThreadT *p;
		unsigned long cur_tick = RBTOS_dwCurTick;
		
		lsActvThreads = next;
		
		if (lsTmWaitThreads == NULL) {
			dwPrevTick = cur_tick;
		} else {
			unsigned long passing_ticks = cur_tick - dwPrevTick;
			ticks += passing_ticks;
			if (ticks < passing_ticks) {
				ticks = 0xFFFFFFFFUL;
			}
		}
		pp = &lsTmWaitThreads;
		while (1) {
			p = *pp;
			if ((p == NULL) || (ticks < p->dwSleepTick)) {
				break;
			}
			pp = &p->pLstNext;
		}
		*pp = cur;
		cur->dwSleepTick = ticks;
		cur->pLstNext = p;
		RBTOS_Thread_switch();
	}
	RBTOS_set_imask(ccr);
}


/*****************************************************************************
 * XbhGg
 * (Main, AChXbhȊÓjׂẴXbh̊Jn֐
 *****************************************************************************/
static void xThreadEntry(void *arg, void (*funcThread)(void *arg))
{
	funcThread(arg);
	xThreadDestroy();
}


/*****************************************************************************
 * JgXbh OS 菜.
 * Xbh֐IɌĂ΂.
 *****************************************************************************/
static void xThreadDestroy(void)
{
	RBTOS_ThreadT *cur;
	RBTOS_ThreadT *next;
	
	RBTOS_disable();
	
	// Jg^XNANeBu^XNXg菜.
	RBTOS_assert(pCurThread == lsActvThreads);
	cur = pCurThread;
	next = cur->pLstNext;
    lsActvThreads = next;
    
	// JgXbh̎ɗDx̍Xbhɐ؂ւ.
	RBTOS_Thread_switch();
}


/*****************************************************************************
 * bN
 *****************************************************************************/
void RBTOS_Lock_enter(RBTOS_LockT *lock)
{
	RBTOS_ThreadT *cur;
	RBTOS_CCR_ELEM_T ccr = RBTOS_disable();
	cur = pCurThread;
	RBTOS_assert(cur == lsActvThreads);
	if (lock->owner == NULL) {
		// NbNĂȂꍇCJgXbhL҂ɂďI.
		lock->owner = cur;
	} else if (lock->owner == cur) {
		// JgXbhL҂̏ꍇCbNJEg +1 ďI.
		lock->bCount++;
	} else {
		// JgXbhANeBuXg菜
		RBTOS_ThreadT **pp;
		RBTOS_ThreadT *p;
		RBTOS_ThreadT *next = cur->pLstNext;
		lsActvThreads = next;
		cur->pLstNext = NULL;
		
		pp = &lock->pWaitingList;
		while (1) {
			p = *pp;
			if ((p == NULL) || (cur->bPriority < p->bPriority)) {
				break;
			}
			pp = &p->pObjNext;
		}
		*pp = cur;
		cur->pObjNext = p;
		
		RBTOS_Thread_switch();
	}
	RBTOS_set_imask(ccr);
}

void RBTOS_Lock_leave(RBTOS_LockT *lock)
{
	RBTOS_CCR_ELEM_T ccr = RBTOS_disable();
	RBTOS_assert(pCurThread == lsActvThreads);
	RBTOS_assert(pCurThread == lock->owner);
	if (lock->bCount != 0) {
		lock->bCount--;
	} else {
		RBTOS_ThreadT *next = lock->pWaitingList;
		lock->owner = next;
		if (next != NULL) {
			lock->pWaitingList = next->pObjNext;
			next->pObjNext = NULL;
			xAddToActiveThreadList(next);
			if (pCurThread != lsActvThreads) {
				RBTOS_Thread_switch();
			}
		}
	}
	RBTOS_set_imask(ccr);
}

/*****************************************************************************
 * Cxg
 *****************************************************************************/

// Cxg҂
int RBTOS_Event_wait(RBTOS_EventT *pevent, unsigned long ticks)
{
	RBTOS_ThreadT *cur;
	RBTOS_ThreadT *next;
	RBTOS_ThreadT **pp;
	RBTOS_ThreadT *p;
	RBTOS_CCR_ELEM_T ccr = RBTOS_disable();
	if (pevent->fSignaled) {
		// CxgVOiԂȂ΁CVOiԂNAďI.
		pevent->fSignaled = 0;
		RBTOS_set_imask(ccr);
		return 0;
	}
	// ANeBuXg菜
	cur = pCurThread;
	RBTOS_assert(cur == lsActvThreads);
	next = cur->pLstNext;
	lsActvThreads = next;
	
	pp = &pevent->pWaitingList;
	while (1) {
		p = *pp;
		if ((p == NULL) || (cur->bPriority < p->bPriority)) {
			break;
		}
		pp = &p->pObjNext;
	}
	*pp = cur;
	cur->pObjNext = p;
	
	if (ticks == 0) {
		cur->pLstNext = NULL;
	} else {
		unsigned long cur_tick = RBTOS_dwCurTick;
		if (lsTmWaitThreads == NULL) {
			dwPrevTick = cur_tick;
		} else {
			unsigned long passing_ticks = cur_tick - dwPrevTick;
			ticks += passing_ticks;
			if (ticks < passing_ticks) {
				ticks = 0xFFFFFFFFUL;
			}
		}
		pp = &lsTmWaitThreads;
		while (1) {
			p = *pp;
			if ((p == NULL) || (ticks < p->dwSleepTick)) {
				break;
			}
			pp = &p->pLstNext;
		}
		*pp = cur;
		cur->pLstNext = p;
	}
	cur->dwSleepTick = ticks;
	cur->fIsTimedOut = 1;
	cur->pEvent = pevent;
	RBTOS_Thread_switch();
	RBTOS_set_imask(ccr);
	return cur->fIsTimedOut;
}

// CxgZbg
void iRBTOS_Event_set(RBTOS_EventT *pevent)
{
	RBTOS_CCR_ELEM_T ccr = RBTOS_disable();
	RBTOS_ThreadT *p = pevent->pWaitingList;
	
	if (p == NULL) {
		// Cxg҂ĂXbhȂCVOiԂɂďI.
		pevent->fSignaled = 1;
		RBTOS_set_imask(ccr);
		return;
	}
	pevent->pWaitingList = NULL;
	do {
		RBTOS_ThreadT **pp;
		RBTOS_ThreadT *next = p->pObjNext;
		
		if (p->dwSleepTick != 0) {
			for (pp = &lsTmWaitThreads; *pp != NULL; pp = &(*pp)->pLstNext) {
				if (*pp == p) {
					*pp = p->pLstNext;
					break;
				}
			}
		}
		p->pObjNext = NULL;
		p->pLstNext = NULL;
		p->pEvent = NULL;
		p->fIsTimedOut = 0;
		xAddToActiveThreadList(p);
		
		p = next;
	} while (p != NULL);
	RBTOS_set_imask(ccr);
}


// CxgZbg
void RBTOS_Event_set(RBTOS_EventT *pevent)
{
	RBTOS_CCR_ELEM_T ccr = RBTOS_disable();
	RBTOS_ThreadT *p = pevent->pWaitingList;
	
	if (p == NULL) {
		// Cxg҂ĂXbhȂCVOiԂɂďI.
		pevent->fSignaled = 1;
		RBTOS_set_imask(ccr);
		return;
	}
	pevent->pWaitingList = NULL;
	do {
		RBTOS_ThreadT **pp;
		RBTOS_ThreadT *next = p->pObjNext;
		
		if (p->dwSleepTick != 0) {
			for (pp = &lsTmWaitThreads; *pp != NULL; pp = &(*pp)->pLstNext) {
				if (*pp == p) {
					*pp = p->pLstNext;
					break;
				}
			}
		}
		p->pObjNext = NULL;
		p->pLstNext = NULL;
		p->pEvent = NULL;
		p->fIsTimedOut = 0;
		xAddToActiveThreadList(p);
		
		p = next;
	} while (p != NULL);
	RBTOS_Thread_switch();
	RBTOS_set_imask(ccr);
}

static void xIdleThreadFunc(void *arg)
{
	while (1) {
		Idle();
	}
}

static void xAddToActiveThreadList(RBTOS_ThreadT *pTask)
{
	// ANeBuXĝׂꏊɑ}o^.
	RBTOS_ThreadT **pp = &lsActvThreads;
	while (1) {
		RBTOS_ThreadT *p = *pp;
		if ((p == NULL) || (p->bPriority > pTask->bPriority)) {
			pTask->pLstNext = p;
			*pp = pTask;
			break;
		}
		pp = &p->pLstNext;
	}
}


void __attribute__((__interrupt__,auto_psv)) _OscillatorFail(void)
{
        INTCON1bits.OSCFAIL = 0;        //Clear the trap flag
//		LATAbits.LATA0 = 1; // LED1
//		LATAbits.LATA1 = 1; // LED2
//		LATBbits.LATB4 = 1; // LED3
        while (1);
}
void __attribute__((__interrupt__,auto_psv)) _AddressError(void)
{
        INTCON1bits.ADDRERR = 0;        //Clear the trap flag
//		LATAbits.LATA0 = 0; // LED1
//		LATAbits.LATA1 = 1; // LED2
//		LATBbits.LATB4 = 1; // LED3
        while (1);
}

//void __attribute__((__interrupt__,auto_psv)) _StackError(void)
void StackErrorFunc(unsigned long errorAddr, unsigned short splim, unsigned short stack)
{
        INTCON1bits.STKERR = 0;         //Clear the trap flag
#if (RBTOS_CONF_HAVE_DEVICE == 1)
		fCritical = 1;
		con_printf(ERROR_COLOR "\nStackError!!!\n");
		con_printf("- Address: 0x%08lX, SPLIM: 0x%04X, STACK(W15):0x%04X\n", errorAddr, splim, stack);
		con_printf("- CurrentThread: %s\n", pCurThread->strName);
		con_printf(NORMAL_COLOR);
#endif /* (RBTOS_CONF_HAVE_DEVICE == 1) */
        while (1);
}
void __attribute__((__interrupt__,auto_psv)) _MathError(void)
{
        INTCON1bits.MATHERR = 0;        //Clear the trap flag
//		LATAbits.LATA0 = 0; // LED1
//		LATAbits.LATA1 = 0; // LED2
//		LATBbits.LATB4 = 1; // LED3
        while (1);
}
