//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "window.h"
#include "graphic.h"
#include "view.h"

//	OO[o
extern int g_DispWidth;
extern int g_DispHeight;

/*
 *	X ̉]
 *
 *	v	: ]piradj
 *
 *	]́̕{ɍew̐lw̕
 */
void RotVX(float v){
	VMTX_ROT(D3DXMatrixRotationX, -v);
}

/*
 *	Y ̉]
 *
 *	v	: ]piradj
 */
void RotVY(float v){
	VMTX_ROT(D3DXMatrixRotationY, -v);
}

/*
 *	ỷ]
 *
 *	v	: ]piradj
 */
void RotVZ(float v){
	VMTX_ROT(D3DXMatrixRotationZ, -v);
}

/*
 *	UpxNg̉]
 *
 *	v	: ]piradj
 */
void RotVUp(float v){
	VMTX_ROTA(D3DXVECTOR3(VMTX_21, VMTX_22, VMTX_23), v);
}

/*
 *	ړ
 *
 *	v	: ړxNg
 */
void MoveV(VEC3 v){
	VMTX_MOVE(D3DXMatrixTranslation, -v);
}

/*
 *	ړi[hWnj
 *
 *	v	: ړxNg
 */
void MoveVW(VEC3 v){
	VMTX_MOVEW(D3DXMatrixTranslation, -v);
}

/*
 *	ʒuݒ
 *
 *	v	: ʒuxNg
 */
void SetVPos(VEC3 v){
	VMTX_MOVEW(D3DXMatrixTranslation, GetVPos()-v);
}

/*
 *	ʒuAp̐ݒ
 *
 *	posFʒu
 *	dirF
 *	up FxNg
 */
void SetView(VEC3 pos, VEC3 dir, VEC3 up){
	D3DXMatrixLookAtLH(&sv3.mtxView, &pos, &dir, &up);
}

/*
 *	r[|[gݒ
 */
void SetViewport(DWORD x, DWORD y, DWORD w, DWORD h, float znear, float zfar){
	D3DVIEWPORT8 vp;
	vp.X = x;
	vp.Y = y;
	vp.Width = w;
	vp.Height = h;
	vp.MinZ = znear;
	vp.MaxZ = zfar;
	sv3.pDev->SetViewport(&vp);

	//r[|[gs̍쐬([hXN[Wϊp)
	sv3.mtxVPort = MTX4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1);
	sv3.mtxVPort._11 =  (w*0.5f);
	sv3.mtxVPort._22 = -(h*0.5f);
	sv3.mtxVPort._41 =  (w*0.5f)+x;
	sv3.mtxVPort._42 =  (h*0.5f)+y;
}

/*
 *	̐ݒ
 *
 *	at	F_
 */
void LookAtV(VEC3 at){
	VEC3 up(0, 1, 0);
	VEC3 pos = GetVPos();
	D3DXMatrixLookAtLH(&sv3.mtxView, &pos, &at, &up);
}

/*
 *	[hWXN[Wւ̕ϊ
 *
 *	JɂꍇZl-1
 */
VEC3 WorldToScreen(VEC3 pos){
	VEC3 out;

	D3DXVec3TransformCoord(&out, &pos, &sv3.mtxWtoS);
	if(D3DXVec3Dot(&(pos-GetVPos()), &GetVDir())>=0){
		out.z = 0.0f;
	}else{
		out.z = -1.0f;
		out.x = g_DispWidth-out.x;
		out.y = g_DispHeight-out.y;
	}
	return out;
}

/*
 *	XN[W烏[hWւ̕ϊ
 *
 *	pos.z0œn
 */
VEC3 ScreenToWorld(VEC3 pos){
	VEC3 v3;
	D3DXVec3TransformCoord(&v3, &pos, &sv3.mtxStoW);
	return VEC3(v3.x, v3.y, v3.z);
}
