//	Copyright (c) 2002 Midikyou


using namespace std;

#define UDX_TEXTURE_MEASURE (0)

#if UDX_TEXTURE_MEASURE
#include <vector>
#include <string>
#include "..\CJobTimer.h"
#endif

/*
 *	eNX`[̓Ǎ
 *
 *	ppTex		: Ǎݐ
 *	strFile	: t@C
 *	cTrans	: ߐF
 *	nMipLv	: ~bv}bvEx
 *
 *	TCYQ̏搔łȂꍇ͎Iɓȗ̈悪ǉB
 */
inline HRESULT LOAD_TEXTURE(
	LPTEX8 *ppTex, LPCSTR strFile, D3DCOLOR cTrans = 0, int nMipLv = 1){
	HRESULT hr;

	hr = D3DXCreateTextureFromFileExA(
		sv3.pDev, strFile, 0, 0, nMipLv, 0,
		D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
		D3DX_DEFAULT, D3DX_DEFAULT,
		cTrans, NULL, NULL, ppTex);
	return hr;
}
//	VXe
inline HRESULT LOAD_TEXTURE_SYS(
	LPTEX8 *ppTex, LPCSTR strFile, D3DCOLOR cTrans = 0, int nMipLv = 1){
	HRESULT hr;

	hr = D3DXCreateTextureFromFileExA(
		sv3.pDev, strFile, 0, 0, nMipLv, 0,
		D3DFMT_A8R8G8B8, D3DPOOL_SYSTEMMEM,
		D3DX_DEFAULT, D3DX_DEFAULT,
		cTrans, NULL, NULL, ppTex);
	return hr;
}
//	\[X
inline HRESULT LOAD_TEXTURE_RES(
	LPTEX8 *ppTex, LPCSTR strRes, D3DCOLOR cTrans = 0, int nMipLv = 1){
	HRESULT hr;

	hr = D3DXCreateTextureFromResourceExA(
		sv3.pDev, NULL, strRes, 0, 0, nMipLv, 0,
		D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
		D3DTEXF_POINT, D3DTEXF_POINT,
		cTrans, NULL, NULL, ppTex);
	return hr;
}

/*
 *	eNX`ENX
 */
class CTexture{
	BOOL m_fCreate;				//	tO
	LPTEX8			m_pTex;		//	eNX`EIuWFNg
	D3DSURFACE_DESC	m_desc;		//	TCY̏

	//	Rs[RXgN^
	CTexture& operator = (const CTexture&){return *this;}
public:
	CTexture();
	~CTexture();

	BOOL Load(LPCSTR strFile, D3DCOLOR cTrans = 0, int nMipLv = 1);
	BOOL LoadResource(LPCSTR strRes, D3DCOLOR cTrans = 0, int nMipLv = 1);
	void Free();

	BOOL Create(int w, int h);
	BOOL DrawInText(int x, int y, LPCSTR str, HFONT hFont,
		D3DCOLOR col = 0xffffffff, D3DCOLOR sdw = 0, int w = -1, int h = -1);
	void Render(int x, int y);

	/*
	 *	TCY̎擾iQ̏搔TCYɑj
	 *
	 *	pSize	: TCY̊i[
	 */
	void GetSize(int *pW, int *pH){*pW = m_desc.Width, *pH = m_desc.Height;}
	/*
	 *	eNX`EIuWFNg̎擾
	 */
	LPTEX8 GetObject(){ return m_pTex; }
	/*
	 *	T[tFCX̎擾
	 */
	void GetSurface(LPSURF8 *ppSur){m_pTex->GetSurfaceLevel(0, ppSur);}
};

//	eNX`Xg̗vf
struct TEXINFO{
	LPTEX8 pTex;
	string strName;
	int nRef;
	D3DCOLOR cTrans;
	int nMipLv;
	TEXINFO *pNext;
};

/*
 *	eNX`XgENX (CMeshNXŎgp)
 *	EeNX`[dɃ[hȂ悤ɂB
 *	EQƐĎAgpĂȂeNX`[B
 */
class CTexList{
	TEXINFO *m_pList;	//	Xg̐擪
public:
	CTexList();
	~CTexList();
	LPTEX8 Get(BOOL fRes, LPCSTR strName, D3DCOLOR cTrans = 0, int nMipLv = 1);
	void Release(LPTEX8 pTex);
};

/*
 *	eNX`Xe[WEXe[g̐ݒ
 *
 *	stage	FXe[W
 *	param	Fp[^
 *	state	F
 */
inline void devSetTexState(DWORD stage, D3DTEXTURESTAGESTATETYPE pram, DWORD state){
	sv3.pDev->SetTextureStageState(stage, pram, state);
}

/*
 *	eNX`̐ݒ
 *
 *	n		: Xe[W
 *	pTex	: eNX`
 */
inline void devSetTexture(DWORD n, LPTEX8 pTex){
#if UDX_TEXTURE_MEASURE
	TIMER_RAII("devSetTexture");
#endif
	sv3.pDev->SetTexture(n, pTex);
}

/*
 *	eNX`̎擾
 *
 *	n		: Xe[W
 */
inline LPTEX8 devGetTexture(DWORD n){
	IDirect3DBaseTexture8 *pTex;
	sv3.pDev->GetTexture(n, &pTex);
	return (LPTEX8)pTex;
}

/*
 *	eNX`[J[̐ݒ
 *
 *	stage	: eNX`[Xe[W
 *	op	: Z^Cv
 *	arg1	: P
 *	arg2	: Q
 */
inline void devSetTexColor(
	DWORD stage,
	DWORD op = D3DTOP_MODULATE,
	DWORD arg1 = D3DTA_TEXTURE,
	DWORD arg2 = D3DTA_DIFFUSE	){
	devSetTexState(stage, D3DTSS_COLOROP, op);
	devSetTexState(stage, D3DTSS_COLORARG1, arg1);
	devSetTexState(stage, D3DTSS_COLORARG2, arg2);
}

//	W̃}bsO
#define devTEX_SINGLE() devSetTexState(1, D3DTSS_COLOROP, D3DTOP_DISABLE)
//	Cg}bsOiVOpXj
#define devTEX_LIGHTMAP() devSetTexColor(1, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_CURRENT)
//	}bsOiVOpXj
#define devTEX_ENVMAP() devSetTexColor(1, D3DTOP_ADDSMOOTH, D3DTA_TEXTURE, D3DTA_CURRENT)

/*
 *	eNX`[̐ݒ
 *
 *	stage	: eNX`[Xe[W
 *	op	: Z^Cv
 *	arg1	: P
 *	arg2	: Q
 */
inline void devSetTexAlpha(
	DWORD stage,
	DWORD op = D3DTOP_MODULATE,
	DWORD arg1 = D3DTA_TEXTURE,
	DWORD arg2 = D3DTA_DIFFUSE	){
	devSetTexState(stage, D3DTSS_ALPHAOP, op);
	devSetTexState(stage, D3DTSS_ALPHAARG1, arg1);
	devSetTexState(stage, D3DTSS_ALPHAARG2, arg2);
}

/*
 *	eNX`[tB^[̐ݒ
 *
 *	stage	: eNX`[Xe[W
 *	type	: tB^[^Cv
 *
 *	D3DTEXF_NONE	: tB^Ȃ
 *	D3DTEXF_POINT	: ŋߓ_⊮
 *	D3DTEXF_LINEAR	: `⊮
 *	etc...
 */
inline void devSetTexFilter(DWORD stage, DWORD type){
	devSetTexState(stage, D3DTSS_MAGFILTER, type);
	devSetTexState(stage, D3DTSS_MINFILTER, type);
	devSetTexState(stage, D3DTSS_MIPFILTER, type);
}

#define devTEX_NONE(stage) devSetTexFilter(stage, D3DTEXF_NONE)
#define devTEX_POINT(stage) devSetTexFilter(stage, D3DTEXF_POINT)
#define devTEX_LINEAR(stage) devSetTexFilter(stage, D3DTEXF_LINEAR)

/*
 *	eNX`[AhbVO[h̐ݒ
 *
 *	stage	: eNX`[Xe[W
 *	mode	: AhbVO[h
 *
 *	D3DTADDRESS_WRAP		: bviftHgj
 *	D3DTADDRESS_MIRROR		: ~[
 *	D3DTADDRESS_CLAMP		: Nv
 *	D3DTADDRESS_BORDER		: EF
 *	D3DTADDRESS_MIRRORONCE	: ~[Q
 */
inline void devSetTexAddress(DWORD stage, D3DTEXTUREADDRESS mode){
	devSetTexState(stage, D3DTSS_ADDRESSU, mode);
	devSetTexState(stage, D3DTSS_ADDRESSV, mode);
}

#define devTEX_WRAP()		devSetTexAddress(0, D3DTADDRESS_WRAP)
#define devTEX_MIRROR()		devSetTexAddress(0, D3DTADDRESS_MIRROR)
#define devTEX_CLAMP()		devSetTexAddress(0, D3DTADDRESS_CLAMP)
#define devTEX_BORDER()		devSetTexAddress(0, D3DTADDRESS_BORDER)
#define devTEX_MIRROR2()	devSetTexAddress(0, D3DTADDRESS_MIRRORONCE)

/*
 *	eNX`[gXtH[ON/OFF
 *
 *	stage	: eNX`[Xe[W
 *	f		: tO
 */
inline void devSetTexTrans(DWORD stage, BOOL f){
	devSetTexState(
		stage,
		D3DTSS_TEXTURETRANSFORMFLAGS, f ? D3DTTFF_COUNT2 : D3DTTFF_DISABLE);
}

/*
 *	eNX`[gXtH[
 *
 *	stage	: eNX`[Xe[W
 *	pMtx	: ϊs
 *
 *	OdevSetTexTrans()TUREݒ肷邱ƁB
 */
inline void devTexTransform(DWORD stage, MTX4 *pMtx){
	sv3.pDev->SetTransform(
		(D3DTRANSFORMSTATETYPE)(D3DTS_TEXTURE0+stage), pMtx);
}

/*
 *	}bv̐ݒ
 *
 *	stage	: eNX`[Xe[W
 *	f		: tO
 */
inline void devSetEnvMap(DWORD stage, BOOL f){
	devSetTexTrans(stage, f);
	devTexTransform(stage, f
		? &MTX4(
			0.5f,  0.0f, 0.0f, 0.0f,
			0.0f, -0.5f, 0.0f, 0.0f,
			0.5f,  0.5f, 1.0f, 0.0f,
			0.0f,  0.0f, 0.0f, 1.0f)
		: &MTX_FRONT);
	devSetTexState(stage, D3DTSS_TEXCOORDINDEX,
		f ? D3DTSS_TCI_CAMERASPACENORMAL : D3DTSS_TCI_PASSTHRU);
}

//	֐錾
D3DCOLOR CheckTexTrans(LPCSTR str);
void CalcTextRect(int *w, int *h, LPCSTR str, HFONT hFont);
