//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "window.h"
#include "sound.h"

/*
 *	DirectSound̏
 */
BOOL InitDirectSound(){
	DebugHL();
	Debug("InitDirectSound\n");

//	FAILED_ASSERT(
//		"DirectSound̏Ɏs܂.",
//		DirectSoundCreate8(NULL, &svs.pDS, NULL));
	if(FAILED(DirectSoundCreate8(NULL, &svs.pDS, NULL))){
		svs.pDS = NULL;
		return TRUE;
	}

	FAILED_ASSERT(
		"TEh̋xݒł܂.",
		svs.pDS->SetCooperativeLevel(svw.hWnd, DSSCL_PRIORITY));

	//	vC}obt@̍쐬
	return CreatePrimaryBuffer();
}

/*
 *	DirectSound̉
 */
void FreeDirectSound(){
	if(!svs.pDS || !svs.pPB) return;
	DebugHL();
	Debug("FreeDirectSound\n");

	SetMasterVolume();	//	{[ɖ߂
	RELEASE(svs.pListener);
	RELEASE(svs.pPB);
	RELEASE(svs.pDS);
}

/*
 *	vC}obt@̍쐬
 */
BOOL CreatePrimaryBuffer(){
	//	3DTEhgp邩ǂH
	Debug("3DTEh = ");

	if(CheckArguments("/3ds")){
		svs.f3D = FALSE;
		Debug("OFF\n");
	}else{
		svs.f3D = TRUE;
		Debug("ON\n");
	}
	//	FXgp邩ǂH
	Debug("GtFNg = ");

	if(CheckArguments("/fx")){
		svs.fFX = FALSE;
		Debug("OFF\n");
	}else{
		//svs.fFX = TRUE;
		svs.fFX = FALSE;
		Debug("ON\n");
	}
	DSBUFFERDESC desc;

	ZeroMemory(&desc, sizeof(DSBUFFERDESC));
	desc.dwSize = sizeof(DSBUFFERDESC);
	desc.dwFlags = DSBCAPS_CTRLVOLUME|DSBCAPS_PRIMARYBUFFER;

	if(svs.f3D) desc.dwFlags |= DSBCAPS_CTRL3D;

	FAILED_ASSERT(//	vC}obt@ɂIDirectSoundBuffer8gpłȂ
		"vC}ETEhobt@쐬ł܂.",
		svs.pDS->CreateSoundBuffer(&desc, &svs.pPB, NULL));
	//	EF[utH[}bg̐ݒ
	WAVEFORMATEX wfmt = GetWaveFormat(44100, 16, 2);

	FAILED_ASSERT(
		"TEhtH[}bgwł܂.",
		svs.pPB->SetFormat(&wfmt));
	//	{[̎擾
	svs.pPB->GetVolume(&svs.initVolume);

	if(svs.f3D){
		//	Xi[̍쐬
		FAILED_ASSERT(
			"3DXi[쐬ł܂.",
			svs.pPB->QueryInterface(IID_IDirectSound3DListener, (void **)&svs.pListener));

		SetListenerSens(1.0f);
		SetListenerPos(VEC3(0, 0, 0));
		SetListenerDir(VEC3(0, 0, 1), VEC3(0, 1, 0));
	}
	return TRUE;
}

/*
 *	vC}obt@̌
 */
void PrimaryBufferVerify(){
	if(!svs.pPB) return;
	DWORD dw;

	svs.pPB->GetStatus(&dw);

	//	Xg͕
	if(dw&DSBSTATUS_BUFFERLOST){
		Debug("PB:DSBSTATUS_BUFFERLOST");
		svs.pPB->Restore();
	}
}

/*
 *	}X^[{[̐ݒ
 *
 *	dB	: DSBVOLUME_MIN-DSBVOLUME_MAX(1/100dBP)
 *
 *	DirectMusicƘAB
 */
void SetMasterVolume(LONG dB){
	if(!svs.pPB) return;
	svs.pPB->SetVolume(dB);
}

/*
 *	Xi[̊xݒ
 */
void SetListenerSens(float f){
	if(svs.f3D)
		svs.pListener->SetDistanceFactor(f, DS3D_IMMEDIATE);
}

/*
 *	Xi[̈ʒuݒ
 */
void SetListenerPos(VEC3 v){
	if(svs.f3D)
		svs.pListener->SetPosition(v.x, v.y, v.z, DS3D_IMMEDIATE);
}

/*
 *	Xi[̕ݒ
 *
 *	d		: Z
 *	u		: Y
 */
void SetListenerDir(VEC3 d, VEC3 u){
	if(svs.f3D)
		svs.pListener->SetOrientation(d.x, d.y, d.z, u.x, u.y, u.z, DS3D_IMMEDIATE);
}
