//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "graphic.h"
#include "texture.h"
#include "offscreen.h"

/*
 *	RXgN^
 */
COffScreen::COffScreen(){
	m_pTex = NULL;
	m_pRT = NULL;
	m_pZB = NULL;
	m_fRender = FALSE;
}

/*
 *	fXgN^
 */
COffScreen::~COffScreen(){
	Free();
}

/*
 *	T[tFCX̍쐬
 *
 *	w, h	: TCY@2̏搔̂
 */
BOOL COffScreen::Create(int w, int h){
	Free();	//	Ȃ

	HRESULT hr;

	hr = sv3.pDev->CreateTexture(
		w, h, 1, D3DUSAGE_RENDERTARGET,
		sv3.d3dpp.BackBufferFormat,
		D3DPOOL_DEFAULT, &m_pTex);
	if(FAILED(hr)) return FALSE;

	//	̂D3DUSAGE_DEPTHSTENCILŃeNX`쐬łȂ̂ŁEEE
	hr = sv3.pDev->CreateDepthStencilSurface(
		w, h,
		sv3.d3dpp.AutoDepthStencilFormat,
		sv3.d3dpp.MultiSampleType,
		&m_pZB
	); 
	if(FAILED(hr)) return FALSE;

	m_fRender = TRUE;
	return TRUE;
}

/*
 *	T[tFCX̉
 */
void COffScreen::Free(){
	m_fRender = FALSE;

	RELEASE(m_pTex);
	RELEASE(m_pZB);
}

/*
 *	_OJn
 */
BOOL COffScreen::Begin(D3DCOLOR c){
	if(!m_fRender) return FALSE;

	//	݂̃XN[ݒޔ
	sv3.pDev->GetRenderTarget(&m_pOldRT);
	sv3.pDev->GetDepthStencilSurface(&m_pOldZB);

	//	VXN[ݒZbg
	m_pTex->GetSurfaceLevel(0, &m_pRT);

	if(FAILED(sv3.pDev->SetRenderTarget(m_pRT, m_pZB)))
		return FALSE;

	//	V[̊Jn
	if(!BeginScene(c)) return FALSE;
	return TRUE;
}

/*
 *	_OI
 */
void COffScreen::End(){
	if(!m_fRender) return;

	//	V[̏IAXN[ݒ̕
	sv3.pDev->EndScene();
	RELEASE(m_pRT);

	sv3.pDev->SetRenderTarget(m_pOldRT, m_pOldZB);
	RELEASE(m_pOldRT);
	RELEASE(m_pOldZB);
}
