//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "frame.h"
#include "window.h"
#include "graphic.h"
#include "draw.h"
#include "texture.h"
#include "font.h"
#include "input.h"
#include "sound.h"
#include "wave.h"
#include "mesh.h"
#include "object.h"
#include "editbox.h"
#include "..\Const.h"
#include "..\Macro.h"
#include "..\SystemCover.h"
#include "..\CSkinPlugin.h"

//	֐錾
string EliminateTabAndCRLF(string);

//	萔
const int BLINK_FRAME = MAXFPS/2;	//	_ŊԊu
const int BASE_MARGINX = 1;			//	ҏẄ]

//	static o
bool CEditBox::ms_Active = false;

/*
 *	RXgN^
 */
CEditBox::CEditBox(){
	m_hImc = NULL;
//	m_pList = NULL;
	m_str = "";
	m_x = 0;
	m_y = 0;
	m_pos = m_selpos = 0;
	m_max = 80;
}

/*
 *	fXgN^
 */
CEditBox::~CEditBox(){
	Release();
}

/*
 *	GfBbg{bNX쐬
 *
 *	x	: \Jn X W
 *	y	: \Jn Y W
 *	max	: ő啶
 *	imm : 0:s, 1:ON, -1:OFF
 */
void CEditBox::Create(int x, int y, int w, int max, string pre, int imm){
	Release(imm);
	ms_Active = true;
	m_hImc = ImmGetContext(svw.hWnd);
	if(imm) ImmSetOpenStatus(m_hImc, imm>0);
	m_comp = "";
	pre = EliminateTabAndCRLF(pre);
	m_x = x;
	m_y = y;
	m_width = w;
	m_pos = pre.size();
	m_selpos = 0;
	m_max = max;
	m_str = m_show = pre;
	m_frame = 0;
	m_oldsize = 0;
	m_old_iscomp = FALSE;
	ClearCharQueue();
}

/*
 *	GfBbg{bNX
 */
void CEditBox::Release(int imm){
	ms_Active = false;
	if(m_hImc){
		if(imm) ImmSetOpenStatus(m_hImc, imm>0);
		ImmReleaseContext(svw.hWnd, m_hImc);
		m_hImc = 0;
	}
}

/*
 *	̓`FbN
 */
int CEditBox::ScanInput(){
	//	L[ĂȂȂXLbv
	if(CheckKeyDown()<0) return EDIT_PROC;

	BOOL is_comp = FALSE;
	if(ImmGetCompositionString(m_hImc, GCS_COMPCLAUSE, NULL, 0)>0){
		char attr = -1;
		ImmGetCompositionString(m_hImc, GCS_COMPATTR, &attr, 1);
		if(attr!=ATTR_INPUT) is_comp = TRUE;
	}
	BOOL comp_end = m_old_iscomp && !is_comp;
	m_old_iscomp = is_comp;
	//	G^[L[
	bool enter = (GetKey(DIK_RETURN)|GetKey(DIK_NUMPADENTER))==S_PUSH;
	if(enter || comp_end){
		PeekAllMessage();
		//	ϊ̊mŖꍇ͓͏IƌȂ
		if(!IsComp()) return EDIT_OK;

		//	m肵A
		CompEnd(enter);
		return EDIT_PROC;
	}
	//	GXP[vL[
	if(GetKey(DIK_ESCAPE)==S_PUSH){
		//	ϊ̎Ŗꍇ͓͏IƌȂ
		if(!IsComp()) return EDIT_CANCEL;
		else return EDIT_PROC;
	}
	//	FEPNȂϊ̕擾
	int oldsize = m_oldsize;
	if(IsFEPOpen()){
		GetCompStr(m_comp);
		m_oldsize = m_comp.size();
	}else{
		m_oldsize = 0;
	}
	static int rep;
	if(IsComp()){
		//	ϊȂ
		rep = 0;
	}else if(m_oldsize==oldsize){
		//	ϊłȂȂ (FEP̋N̗Lɂ炸)
		int s;
		if((s = GetKey(DIK_BACK))>=S_PUSH){
			if(PickRepeat(&rep, s)) BackSpace();
		}else if((s = GetKey(DIK_DELETE))>=S_PUSH){
			if(PickRepeat(&rep, s)) DeleteChar();
		}else if((s = GetKey(DIK_LEFT))>=S_PUSH){
			if(PickRepeat(&rep, s)) MoveLeft();
		}else if((s = GetKey(DIK_RIGHT))>=S_PUSH){
			if(PickRepeat(&rep, s)) MoveRight();
		}else if(IsFEPOpen() && (s = GetKey(DIK_SPACE))>=S_PUSH){
			if(PickRepeat(&rep, s)) AddString("@");
		}else if(GetKey(DIK_HOME)==S_PUSH){
			MoveHead();
		}else if(GetKey(DIK_END)==S_PUSH){
			MoveLast();
		}else if(CheckCtrl() && GetKey(DIK_A)==S_PUSH){
			SelectAll();
		}else if(CheckCtrl() && GetKey(DIK_X)==S_PUSH){
			ClipCut();
		}else if(CheckCtrl() && GetKey(DIK_C)==S_PUSH){
			ClipCopy();
		}else if(CheckCtrl() && GetKey(DIK_V)==S_PUSH){
			ClipPaste();
		}else{ 
			int c;
			while(c = DequeueChar())
				if(IsPrintChar(c) && (m_selpos!=m_pos || m_str.size()<m_max)) AddChar(c);
		}
	}else{
		m_show = m_str;
	}
	return EDIT_PROC;
}

/*
 *	_O
 */
void CEditBox::Render(){
	devSetTexture(0, NULL);
	ms_Active = true;
	int i, sel1, sel2;
	if(m_pos<m_selpos){ sel1 = m_pos; sel2 = m_selpos; }
	else{ sel1 = m_selpos; sel2 = m_pos; }
	m_show = m_str;
	if(IsComp()){
		//	ϊȂ
		int size = ImmGetCompositionString(m_hImc, GCS_COMPCLAUSE, NULL, 0);
		int n = size/sizeof(int), *pClause = new int[n];
		ImmGetCompositionString(m_hImc, GCS_COMPCLAUSE, pClause, size);
		size = ImmGetCompositionString(m_hImc, GCS_COMPATTR, NULL, 0);
		char *pAttr = new char[size];
		ImmGetCompositionString(m_hImc, GCS_COMPATTR, pAttr, size);

		string tmpstr(&m_str[0], &m_str[m_pos]);
		m_show.insert(m_pos, m_comp);
		int tbw = (m_show.size()+1)*svf.size/2;
		if(tbw<m_width) tbw = m_width;
		if(m_pos<m_selpos){ sel1 += m_comp.size(); sel2 += m_comp.size(); }
		Grad2DRect(m_x-BASE_MARGINX, m_y, m_x+tbw+BASE_MARGINX, m_y+svf.size,
			g_Skin->m_EditCtrlData.m_EditBaseColor);
		if(sel1!=sel2) Grad2DRect(m_x+sel1*svf.size/2, m_y,
			m_x+sel2*svf.size/2, m_y+svf.size, g_Skin->m_EditCtrlData.m_SelectedBaseColor);

		for(i = 0; i<n-1; i++){
			D3DCOLOR col = g_Skin->m_EditCtrlData.
				m_ConvertClauseColor[pAttr[pClause[i]]==ATTR_TARGET_CONVERTED];
			int tx = m_x+((m_pos+pClause[i])*svf.size/2)+1, ty = m_y+svf.size-2;
			int tx2 = m_x+((m_pos+pClause[i+1])*svf.size/2)-1;
			Draw2DLine(tx, ty, tx2, ty, col);
			Draw2DLine(tx, ty+1, tx2, ty+1, col);
		}

		Text(m_x, m_y, g_Skin->m_EditCtrlData.m_EditFontColor, tmpstr.c_str());
		Text(m_x+m_pos*svf.size/2, m_y,
			g_Skin->m_EditCtrlData.m_ConvertFontColor, m_comp.c_str());
		Text(m_x+(m_pos+m_comp.size())*svf.size/2, m_y,
			g_Skin->m_EditCtrlData.m_EditFontColor, &m_str[m_pos]);

		delete [] pClause;
		delete [] pAttr;
	}else{
		//	\
		int tbw = (m_show.size()+1)*svf.size/2;
		if(tbw<m_width) tbw = m_width;
		Grad2DRect(m_x-BASE_MARGINX, m_y, m_x+tbw+BASE_MARGINX, m_y+svf.size,
			g_Skin->m_EditCtrlData.m_EditBaseColor);
		if(sel1!=sel2) Grad2DRect(m_x+sel1*svf.size/2, m_y,
			m_x+sel2*svf.size/2, m_y+svf.size, g_Skin->m_EditCtrlData.m_SelectedBaseColor);
		Text(m_x, m_y, g_Skin->m_EditCtrlData.m_EditFontColor, m_show.c_str());
		//	Lbg\
		DrawCaret();
	}
}

/*
 *	Lbg\
 */
void CEditBox::DrawCaret(){
	m_frame = (m_frame+1)%BLINK_FRAME;
	if(m_frame<BLINK_FRAME/2){
		int tx = m_x+(m_pos*svf.size/2), ty = m_y+svf.size-2;
		Draw2DLine(tx, ty, tx+svf.size/2, ty, g_Skin->m_EditCtrlData.m_ConvertFontColor);
		Draw2DLine(tx, ty+1, tx+svf.size/2, ty+1, g_Skin->m_EditCtrlData.m_ConvertFontColor);
	}
}

/*
 *	Lbgʒu1O
 */
void CEditBox::BackSpace(){
	if(!DeleteSelected()){
		//	݈ʒu 2 ڈȍ~
		if(m_pos>0){
			char *s = (char *)m_str.c_str();
			int j = CharPrev(s, s+m_pos)-s;
			m_str.erase(j, m_pos-j);
			m_selpos = m_pos = j;
		}
		m_show = m_str;
		m_frame = BLINK_FRAME/5;
	}else{
		DeleteSelected();
	}
}

/*
 *	Lbgʒu̕
 */
void CEditBox::DeleteChar(){
	if(!DeleteSelected()){
		if(m_pos<m_str.size()){
			char *s = (char *)m_str.c_str();
			int j = CharNext(s+m_pos)-s;
			m_str.erase(m_pos, j-m_pos);
		}
	}
	m_show = m_str;
	m_frame = BLINK_FRAME/5;
}

/*
 *	Iꂽ
 */
bool CEditBox::DeleteSelected(){
	if(m_pos<m_selpos){
		m_str.erase(m_pos, m_selpos-m_pos);
		m_selpos = m_pos;
	}else if(m_selpos<m_pos){
		m_str.erase(m_selpos, m_pos-m_selpos);
		m_pos = m_selpos;
	}else{
		return false;
	}
	return true;
}

/*
 *	Iꂽ擾
 */
string CEditBox::GetSelected(){
	const char *s = m_str.c_str();
	if(m_pos<m_selpos) return string(s+m_pos, s+m_selpos);
	else if(m_selpos<m_pos) return string(s+m_selpos, s+m_pos);
	else return "";
}

/*
 *	Lbgʒuɕǉ
 *
 *	c		: 
 */
void CEditBox::AddChar(char c){
	DeleteSelected();
	m_str.insert(m_str.begin()+m_pos, c);
	m_selpos = ++m_pos;
	m_show = m_str;
	m_frame = BLINK_FRAME/5;
}

/*
 *	Lbgʒuɕǉ
 *
 *	s		: 
 */
void CEditBox::AddString(string s){
	DeleteSelected();
	ClearCharQueue();
	m_str.insert(m_str.begin()+m_pos, s.begin(), s.end());
	m_selpos = m_pos += s.size();
	Clip();
	m_show = m_str;
	m_frame = BLINK_FRAME/5;
}

/*
 *	Nbv{[hɐ؂
 */
void CEditBox::ClipCut(){
	if(m_selpos==m_pos) return;
	ClipCopy();
	DeleteSelected();
	m_show = m_str;
	m_frame = BLINK_FRAME/5;
}

/*
 *	Nbv{[hɃRs[
 */
void CEditBox::ClipCopy(){
	if(m_selpos==m_pos) return;
	HGLOBAL hText;
	string sel = GetSelected();
	hText = GlobalAlloc(GMEM_DDESHARE | GMEM_MOVEABLE, sel.size()+1);
	lstrcpy((char *)GlobalLock(hText), sel.c_str());
	GlobalUnlock(hText);
	OpenClipboard(svw.hWnd);
	EmptyClipboard();
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

/*
 *	Nbv{[h\t
 */
void CEditBox::ClipPaste(){
	OpenClipboard(svw.hWnd);
	HANDLE hText = GetClipboardData(CF_TEXT);
	if(!hText) return;
	string s = EliminateTabAndCRLF((char *)GlobalLock(hText));
	GlobalUnlock(hText);
	CloseClipboard();
	DeleteSelected();
	ClearCharQueue();
	m_str.insert(m_str.begin()+m_pos, s.begin(), s.end());
	m_selpos = m_pos += s.size();
	Clip();
	m_show = m_str;
	m_frame = BLINK_FRAME/5;
}

/*
 *	LbgɈړ
 */
void CEditBox::MoveLeft(){
	char *s = (char *)m_str.c_str();
	if(m_pos>0) m_pos = CharPrev(s, s+m_pos)-s;
	if(!CheckShift()) m_selpos = m_pos;
	m_frame = BLINK_FRAME/5;
}

/*
 *	LbgEɈړ
 */
void CEditBox::MoveRight(){
	char *s = (char *)m_str.c_str();
	if(m_pos<m_str.size()) m_pos = CharNext(s+m_pos)-s;
	if(!CheckShift()) m_selpos = m_pos;
	m_frame = BLINK_FRAME/5;
}

/*
 *	Lbg擪Ɉړ
 */
void CEditBox::MoveHead(){
	m_pos = 0;
	if(!CheckShift()) m_selpos = m_pos;
	m_frame = BLINK_FRAME/5;
}

/*
 *	LbgŌɈړ
 */
void CEditBox::MoveLast(){
	m_pos = m_str.size();
	if(!CheckShift()) m_selpos = m_pos;
	m_frame = BLINK_FRAME/5;
}

/*
 *	SđI
 */
void CEditBox::SelectAll(){
	m_selpos = 0;
	m_pos = m_str.size();
	m_frame = BLINK_FRAME/5;
}

/*
 *	ϊm
 */
void CEditBox::CompEnd(bool get_result){
	DeleteSelected();
	if(get_result) GetResultStr(m_comp);
	m_str = m_str.insert(m_pos, m_comp);
	m_selpos = m_pos += m_comp.size();
	Clip();			//	ő啶ŃNbv
	m_show = m_str;	//	\XV
	m_comp = "";	//	ϊ̃NA
	ClearCharQueue();
}

/*
 *	
 */
void CEditBox::Clip(){
	int size = m_str.size(), i;
	if(size<=m_max) return;
	char *s = (char *)m_str.c_str();

	//	Sp̐`FbNȂĂ
	for(i = size; i>m_max;){
		int j = CharPrev(s, s+i)-s;
		m_str.erase(j, i-j);
		i = j;
	}
	size = m_str.size();
	if(m_pos>size) m_selpos = m_pos = size;
}

/*
 *	ϊ̕擾
 *
 *	str	: ̊i[
 */
void CEditBox::GetCompStr(string &str){
	LONG size = ImmGetCompositionString(m_hImc, GCS_COMPSTR, NULL, 0);
	char *pBuf = new char[size+1];
	ImmGetCompositionString(m_hImc, GCS_COMPSTR, pBuf, size);
	pBuf[size] = 0;
	str = pBuf;
	delete pBuf;
}

/*
 *	ϊm肵擾
 *
 *	str	: ̊i[
 */
void CEditBox::GetResultStr(string &str){
	LONG size = ImmGetCompositionString(m_hImc, GCS_RESULTSTR, NULL, 0);
	char *pBuf = new char[size+1];
	ImmGetCompositionString(m_hImc, GCS_RESULTSTR, pBuf, size);
	pBuf[size] = 0;
	str = pBuf;
	delete pBuf;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	^uƉs폜
 */
string EliminateTabAndCRLF(string s){
	char *ptr = (char *)s.c_str();
	for(; *ptr; ptr = CharNext(ptr)){
		if(*ptr=='\t') *ptr = ' ';
		else if(*ptr=='\n' || *ptr=='\r') return string(s.begin(), s.begin()+(ptr-s.c_str()));
	}
	return s;
}

/*
 *	t@CI_CAO
 *
 *	file	: t@Ci[
 *	len		: t@C̍ő啶
 *	def		: `("text file" ACӁj
 *	ext		: gq
 *	flag	: TRUE = ݁AFALSE = Ǎ
 *
 *	߂l: TRUE = I𐬌, FALSE = LZAs
 */
BOOL SelectFile(char *file, int len, const char *def, const char *ext, int flag){
	OPENFILENAME ofn;
	char filter[256];

	memset(&ofn, 0, sizeof(OPENFILENAME));
	memset(file, 0, sizeof(file));
	wsprintf(filter, "%s (*.%s)\t*.%s\t\t", def, ext, ext);

	for(int i = 0;i<256;i++){
		if(filter[i]=='\t') filter[i] = '\0';
	}
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = svw.hWnd;
	ofn.lpstrFilter = filter;
	ofn.nFilterIndex = 0;
	ofn.lpstrDefExt = ext;
	ofn.nMaxFile = len;
	ofn.lpstrFile = file;

	BOOL ret;

	if(flag){
		ofn.Flags = OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY;
		ret = GetSaveFileName(&ofn);
	}else{
		ofn.Flags = OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
		ret = GetOpenFileName(&ofn);
	}
	return ret;
}
