#ifndef CTREEELEMENT_H_INCLUDED
#define CTREEELEMENT_H_INCLUDED

const int TREE_ICON_OFS = 2;	//	ACRƕ̋
const int TREE_ICON_MARGIN = 2;	//	]

class CPlugin;
class CPluginListView;

/*
 *	c[vf
 */
class CTreeElement{
	friend class CPluginTree;
	friend class CTreeFileElement;
	friend class CTreeDirElement;
protected:
	static CTreeElement *ms_FocusPrev;	//	tH[JXACȇO
	static CTreeElement *ms_FocusNext;	//	tH[JXACe̎
	int m_State;						//	
	int m_Width;						//	
	bool m_RenameWait;					//	l[҂
	DWORD m_ClickTime;					//	NbN
	POINT m_DownPos;					//	NbNW
	string m_String;					//	
	CEditBox *m_EditBox;				//	̕ύXpGfBbg{bNX
	CTreeDirElement *m_Parent;			//	e
	CTreeElement *m_Brother;			//	Z
	CPluginTree *m_Owner;				//	c[Rg[
public:
	CTreeElement(char *, CTreeDirElement *, CPluginTree *);
	virtual ~CTreeElement(){}
	CTreeDirElement *GetParent(){ return m_Parent; }
	void SetString(char *str){ m_String = str; m_Width = -1; }
	virtual void Delete();
	bool IsInsideItem(int, int, int, int);
	void BeginRename();
	void EndRename(bool);
	void PrepareDrag();
	void RenderDragItem();
	int Compare(CTreeElement *);
	void MergeSort(CTreeElement **, CTreeElement *);
	virtual CTreeFileElement *IsFile(){ return NULL; }
	virtual CTreeDirElement *IsDirectory(){ return NULL; }
	virtual bool IsRenamable() = 0;
	virtual bool ConfirmRename(string &) = 0;
	virtual bool IsDeletable() = 0;
	virtual void Open();
	virtual void PushListElement(CPluginListView *) = 0;
	virtual void Save(FILE *, string) = 0;
	virtual int CountItem(int, int *, bool) = 0;
	virtual int ScanInput(int, int, int, int, int) = 0;
	virtual int Render(int, int, int, int, int) = 0;
};

#endif
