#ifndef CYESNODIALOG_H_INCLUDED
#define CYESNODIALOG_H_INCLUDED

#include "CWindowCtrl.h"
#include "CStaticCtrl.h"
#include "CPushButton.h"
#include "CEditCtrl.h"

class CMenuCommand;

/*
 *	Vv_CAO
 */
class CSimpleDialog: public CWindowCtrl{
private:
	CStaticCtrl m_Label;	//	x
	CPushButton m_OKButton;	//	OK
public:
	CSimpleDialog(char *, char *);
	bool CheckOK(){ return m_OKButton.IsPushed(); }
	int GetWindowState(){ return CheckOK(); }
};

/*
 *	Yes / No _CAO
 */
class CYesNoDialog: public CWindowCtrl{
private:
	CStaticCtrl m_Label;		//	x
	CPushButton m_YesButton;	//	͂
	CPushButton m_NoButton;		//	
	CMenuCommand *m_YesCommand;	//	u͂vĨR}h
	CMenuCommand *m_NoCommand;	//	uvĨR}h
public:
	CYesNoDialog(char *, char *, bool);
	~CYesNoDialog();
	void SetYesCommand(CMenuCommand *cmd){ m_YesCommand = cmd; }
	void SetNoCommand(CMenuCommand *cmd){ m_NoCommand = cmd; }
	bool CheckYes(){ return m_YesButton.IsPushed(); }
	bool CheckNo(){ return m_NoButton.IsPushed(); }
	int GetWindowState(){ return CheckYes() || CheckNo(); }
	bool ScanInputWindow();
};

/*
 *	̓_CAO
 */
class CInputDialog: public CWindowCtrl{
private:
	CStaticCtrl m_Label;		//	x
	CEditCtrl m_Edit;			//	GfBbg{bNX
	CPushButton m_OKButton;		//	͂
	CPushButton m_CancelButton;	//	
public:
	CInputDialog(char *, char *, char *, int);
	char *GetInputText(){ m_Edit.FinishInput(); return m_Edit.GetText(); }
	bool CheckOK(){ return m_OKButton.IsPushed(); }
	bool CheckCancel(){ return m_CancelButton.IsPushed(); }
	int GetWindowState(){ return CheckOK() || CheckCancel(); }
	bool ScanInputWindow();
};

/*
 *	ړ̓_CAO
 */
class CMultiInputDialog: public CWindowCtrl{
private:
	int m_ItemNumber;			//	ACe
	CStaticCtrl *m_Label;		//	x
	CEditCtrl *m_Edit;			//	GfBbg{bNX
	CPushButton m_OKButton;		//	͂
	CPushButton m_CancelButton;	//	
public:
	CMultiInputDialog(char *, int, char **, char **, int *);
	~CMultiInputDialog();
	int GetItemNumber(){ return m_ItemNumber; }
	char *GetInputText(int i){ m_Edit[i].FinishInput(); return m_Edit[i].GetText(); }
	bool CheckOK(){ return m_OKButton.IsPushed(); }
	bool CheckCancel(){ return m_CancelButton.IsPushed(); }
	int GetWindowState(){ return CheckOK() || CheckCancel(); }
	bool ScanInputWindow();
};

//	֐錾
void EnqueueCommonDialog(CWindowCtrl *);
void ProcessCommonDialog();

//	OO[o
extern list<CWindowCtrl *> g_DialogQueue;

#endif
