#ifndef CSCENEEDITMODE_H_INCLUDED
#define CSCENEEDITMODE_H_INCLUDED

#include "C3DPluginMode.h"

class CSurfacePlugin;
class CScene;

/*
 *	V[Xgr[
 */
class CSceneListView: public CListView{
private:
public:
	bool IsRenamable(CListElement *){ return !g_NetworkInitialized; }
	void EndRename(CListElement *);
	void DoubleClick();
};

/*
 *	V[ҏW[h
 */
class CSceneEditMode: public CModelPluginMode{
private:
	CPushButton m_AddButton;		//	qǉ{^
	CScene *m_SelectScene;			//	IV[
	CCamera m_MyCamera;				//	J
	CWindowCtrl m_SceneWindow;		//	V[
	CSceneListView m_SceneListView;	//	V[Xg
	CPopMenu *m_SceneMenu;			//	V[j[
public:
	CSceneEditMode();
	~CSceneEditMode();
	void WindowResized(int, int, CWindowCtrl *);
	CPopMenu *Dispatch(CMDTYPE, DWORD);
	void DoubleClick(CMDTYPE, DWORD);
	CModelPlugin *GetModelPlugin();
	void AddScene(CSurfacePlugin *);
	void DeleteScene(CScene *);
	char *PluginDirName(){ return "Surface"; }
	CPluginList *GetPluginList();
	void EnterModelPlugin();
	CModelInst *ScanInputModelPlugin();
	void RenderModelPlugin();
};

//	OO[o
extern CSceneEditMode *g_SceneEditMode;

#endif
