#ifndef CSAVEFILE_H_INCLUDED
#define CSAVEFILE_H_INCLUDED

class MD5;
class CListView;
class CRailWay;
class CTrainGroup;
class CDiaInstBase;
class CScene;
class CSurfacePlugin;
class CPlatformInst;

/*
 *	Z[ut@C
 */
class CSaveFile{
	friend class CFileMode;
private:
	string m_FileName;			//	t@C
	string m_FileDate;			//	XV
	string m_FileNote;			//	l
	float m_Version;		//	o[W
	int m_Year;					//	N
	int m_Month;				//	
	int m_Day;					//	
	int m_Hour;					//	
	int m_Minute;				//	
	int m_Second;				//	b
	int m_Frame;				//	t[
	int m_DayOfWeek;			//	j
	int m_SumDays;				//	
	int m_GroupNum;				//	Ґ
	int m_SceneNum;				//	V[
	VEC3 m_WindDir1;			//	ωO
	VEC3 m_WindDir2;			//	ω
	int m_WindCount;			//	JE^
	int m_WindTime;				//	ω
	CRailWay *m_WarpList;		//	[v
	CTrainGroup *m_GroupList;	//	Ґ
	CScene *m_SceneList;		//	V[
	int m_NetworkSyncCount;		//	lbg[NJE^
public:
	CSaveFile(bool);
	~CSaveFile();
	char *GetFileName(){ return (char *)m_FileName.c_str(); }
	void SetFileName(char *fname){ m_FileName = fname; }
	int GetMonth(){ return m_Month; }
	void UpdateWind();
	void SetWarpRoot();
	//bool SetRailBlock(char *);
	bool DeleteWarp();
	void AddGroup();
	void DeleteGroup(CTrainGroup *);
	void ListGroup(CListView *);
	void ListGroupDia(CListView *, CDiaInstBase *);
	CTrainGroup *GetTrainGroup(){ return m_GroupList; }
	void DeletePlatform(CPlatformInst *);
	void NumberGroup();
	void NextGroup(bool);
	vector<CTrainGroup *> GetTrainGroupByVector();
	void SetTrainGroupByVector(vector<CTrainGroup *>);
	void ScanInputWarp(int, VEC3, VEC3);
	void ScanInputInst(int, VEC3, VEC3);
	int GetGroupNum(){ return m_GroupNum; }
	CScene *GetSceneList(){ return m_SceneList; }
	void AddScene(CSurfacePlugin *);
	void DeleteScene(CScene *);
	void ListScene(CListView *);
	void NumberScene();
	void NextScene(bool);
	vector<CScene *> GetSceneByVector();
	void SetSceneByVector(vector<CScene *>);
	void RenderScene(int);
	void Simulate(int);
	void ResetSwitch();
	int GetSceneNum(){ return m_SceneNum; }
	int GetSumDays(){ return m_SumDays; }
	double GetDayTime(){
		return (m_Hour+(m_Minute+(m_Second+m_Frame/30.0)/60.0)/60.0)/24.0;
	}
	double GetAbsTime(){ return m_SumDays+GetDayTime(); }
	char *GetTimeText();
	bool Load(const char *, const char *, bool, bool, char **, int *, bool, char *);
	int Save(const char *, const char *, bool, bool);
};

//	OO[o
extern CSaveFile *g_SaveFile;
extern map<void *, void *> g_AddressMap;
extern void *RegisterNewMapAddress(void *);

//	֐錾
void *ReplaceAdr(void *);

#endif
