#ifndef CRAILPLUGIN_H_INCLUDED
#define CRAILPLUGIN_H_INCLUDED

#include "CProfilePlugin.h"

/*
 *	[vOC
 */
class CRailPlugin: public CProfilePlugin{
	friend class CRailBuilder;
	friend class CLineBuildCurve;
	friend class CPierPlugin;
private:
	float m_Gauge;				//	Q[W
	float m_Height;				//	
	float m_SurfaceAlt;			//	[\ʍx
	float m_CantRatio;			//	JgW
	float m_MaxCant;			//	Jgől [deg]
	float m_JointInterval;		//	pڊԊu
	bool m_FlattenCant;			//	Jg
	CWaveArray *m_WheelSound;	//	ԗ։
public:
	static void RenderPreview();
	CRailPlugin(char *);
	~CRailPlugin();
	char *DirName(){ return "Rail"; }
	char *TextName2(){ return "Rail2.txt"; }
	bool Load();
	void SetPreview();
	float CantFunc(float);
	void PlayWheelSound(float, float, VEC3 &);
	void BeforeDump(VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &);
	void AfterDump(VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &);
	void CalcPierPos(VEC3 *, VEC3 *, VEC3 *, VEC3 *);
	CPLUGIN_CASTFUNC(CRailPlugin);
};

/*
 *	[vOCXg
 */
class CRailPluginList: public CProfilePluginList{
private:
public:
	char *DirName(){ return "Rail"; }
	char *TextName2(){ return "Rail2.txt"; }
	char *Default(){ return "Default_JR_Narrow"; }
	CPlugin *NewEntry(char *id){ return new CRailPlugin(id); }
	CPLUGINLIST_CASTFUNC(CRailPlugin);
};

//	OO[o
extern CRailPlugin *g_Rail;
extern CRailPluginList *g_RailPluginList;

#endif
