#ifndef CRAILCONNECTOR_H_INCLUDED
#define CRAILCONNECTOR_H_INCLUDED

#include "CRailLink.h"
#include "CDiaInst.h"

class CTrainGroup;
class CScene;

/*
 *	[RlN^
 */ 
class CRailConnector{
	friend class CRailConnectorLink;
	friend class CRailWay;
private:
	static CRailConnector **ms_Root;	//	ڑ[g
	static float ms_MinDist;			//	ŏo
	static CRailConnector *ms_Detect;	//	o
	void *m_OldAdr;						//	AhX
	int m_Selected;						//	ItO
	int m_Side;							//	is
	int m_TrailPoint[2];				//	g[
	float m_Cant;						//	Jg
	bool m_CantProc;					//	JgtO
	int m_NetPoint;						//	lbg[Np|Cg
	CPointInst m_PointInst;				//	|Cgؑ
	CRailSplitter m_Splitter;			//	q
	CTrainGroup *m_User;				//	ʉߒҐ
	CRailWayLink m_Link[2][2];			//	ڑ[
	CScene *m_Scene;					//	V[
	CRailConnector *m_Next;				//	Xg
public:
	static void SetRoot(CRailConnector **r){ ms_Root = r; }
	static void ResetDetect(){ ms_MinDist = -1.0f; }
	static bool IsDetected(){ return ms_MinDist>=0.0f; }
	static float GetMinDist(){ return ms_MinDist; }
	static CRailConnector *GetDetect(){ return ms_Detect; }
	CRailConnector();
	CRailConnector(VEC3 &, VEC3 &);
	~CRailConnector();
	CRailConnector *Next(){ return m_Next; }
	CRailConnector **NextAdr(){ return &m_Next; }
	int GetSelectFlag(){ return m_Selected; }
	void AddSelectFlag(int s){ m_Selected |= s; }
	void SetSelectFlag(int s){ m_Selected = s; }
	CPointInst *GetPointInst(){ return &m_PointInst; }
	int GetNetPoint(){ return m_NetPoint; }
	void SetNetPoint(int);
	void SwitchNetPoint();
	CRailConnectorLink CreateLink(int s, int p){ return CRailConnectorLink(s, p, this); }
	CRailSplitter GetSplitter(int rev){ return m_Splitter.Get(rev); }
	VEC3 GetPos(){ return m_Splitter.m_Pos; }
	VEC3 GetUp(){ return m_Splitter.m_Up; }
	CTrainGroup *GetUser(){ return m_User; }
	void SetUser(CTrainGroup *group){ m_User = group; }
	CScene *GetScene(){ return m_Scene; }
	CRailConnector *Delete();
	void DeleteGroup(CTrainGroup *g){ m_PointInst.DeleteGroup(g); }
	void RemoveGroup();
	void Stabilize(VEC3);
	int GetLinkCount();
	bool CheckRailBlock(CTrainGroup *);
	void ScanInput(int, VEC3 &, VEC3 &);
	bool Dump();
	void Render(D3DCOLOR, bool);
	void RestoreAddress();
	char *Read(char *);
	void Save(FILE *);
};

//	q
typedef set<CRailConnector *>::iterator ISPRailConnector;

/*
 *	[ڑ
 */
inline void CRailConnectorLink::Connect(
	CRailWayLink &link	//	N
){
	m_Link->m_Link[m_Side][m_Point] = link;
}

/*
 *	[ڑ
 */
inline void CRailConnectorLink::Disconnect(){
	m_Link->m_Link[m_Side][m_Point].m_Link = NULL;
	m_Link = NULL;
}

/*
 *	ڑW߂
 */
inline VEC3 CRailConnectorLink::GetPos(){
	return m_Link->m_Splitter.m_Pos;
}

/*
 *	ڑ right xNg߂
 */
inline VEC3 CRailConnectorLink::GetRight(){
	return m_Side ? -m_Link->m_Splitter.m_Right : m_Link->m_Splitter.m_Right;
}

/*
 *	ڑ up xNg߂
 */
inline VEC3 CRailConnectorLink::GetUp(){
	return m_Link->m_Splitter.m_Up;
}

/*
 *	ڑ dir xNg߂
 */
inline VEC3 CRailConnectorLink::GetDir(){
	return m_Side ? -m_Link->m_Splitter.m_Dir : m_Link->m_Splitter.m_Dir;
}

/*
 *	ڑJgʂ߂
 */
inline float CRailConnectorLink::GetCant(){
	return m_Side ? -m_Link->m_Cant : m_Link->m_Cant;
}

/*
 *	ڑ敪q߂
 */
inline CRailSplitter CRailConnectorLink::GetSplitter(
	int rev	//	]tO
){
	return m_Link->GetSplitter(rev^m_Side);
}

#endif
