#ifndef CRAILBUILDER_H_INCLUDED
#define CRAILBUILDER_H_INCLUDED

#include "CRailWay.h"

class CRailCurve;
class CRailConnectorLink;
class CRailPlugin;
class CTiePlugin;
class CGirderPlugin;

/*
 *	[ݒuq
 */
class CRailBuilder{
private:
	static int ms_CurrentTrack;		//	݂̃gbN
	static int ms_TrackNum;			//	
	static float ms_TrackInterval;	//	Ԋu
	static float ms_TrackShift;		//	S̃Vtg
	static bool ms_LiftRailSurface;	//	[グ
	static VEC3 ms_BeginPosSum;		//	Jnʒua
	static VEC3 ms_BeginDirSum;		//	Jna
	static VEC3 ms_EndPosSum;		//	Iʒua
	static VEC3 ms_EndDirSum;		//	Ia
	bool m_HitFlag;					//	tO
	VEC3 m_Pos;						//	W
	VEC3 m_HitPos;					//	W
	VEC3 m_HitNorm;					//	@
	vector<CRailLinkTemp> m_Link;	//	ڑ
	CRailBuilder *m_Prev;			//	O
	CRailBuilder *m_Next;			//	
public:
	static void ResetDirSum();
	static void SetTrack(int, int, float, bool);
	static int GetCurrentTrack(){ return ms_CurrentTrack; }
	CRailBuilder(VEC3, CRailBuilder *);
	~CRailBuilder();
	CRailBuilder *Pop();
	CRailBuilder *GetPrev(){ return m_Prev; }
	VEC3 GetPos(){ return m_Pos; }
	VEC3 SetPos(VEC3, int);
	bool CheckLink(){
		return ms_CurrentTrack<ms_TrackNum
			&& m_Link.size()>ms_CurrentTrack && m_Link[ms_CurrentTrack].m_Link;
	}
	bool IsLinkEmpty(){
		return !m_Link.size() || m_Link.size()==1 && !m_Link.begin()->m_Link;
	}
	bool IsLinkFilled(){
		return m_Link.size()==ms_TrackNum && m_Link.rbegin()->m_Link;
	}
	CRailLinkTemp &GetLink(){ return m_Link[ms_CurrentTrack]; }
	bool SetLink(CRailLinkTemp &);
	void PushLink(){ if(m_Link.size()<ms_TrackNum) m_Link.push_back(CRailLinkTemp()); }
	bool IsLast();
	void CalcRight(VEC3 *, VEC3 *, VEC3 *, VEC3 *);
	VEC3 CalcSplitPos();
	VEC3 CalcTrackPos(VEC3 *);
	bool Curve(CRailCurve *, CRailPlugin *, CTiePlugin *, CGirderPlugin *);
	void Render(CLineDumpL *, CRailPlugin *, CTiePlugin *, CGirderPlugin *, bool);
	void BuildRail(CRailConnectorLink &, CRailConnectorLink &,
		CRailPlugin *, CTiePlugin *, CGirderPlugin *);
};

#endif
