#ifndef CPROFILEPLUGIN_H_INCLUDED
#define CPROFILEPLUGIN_H_INCLUDED

#include "CPlugin.h"

class CScene;
class CQuadDumpNX;
class CLineDumpN;

/*
 *	ftHg NULL ŏ|C^
 */
template< typename TYPE >
class MapPtrValue {
private:
	TYPE *m_Ptr;
public:
	MapPtrValue(): m_Ptr(NULL){}
	operator TYPE*(){ return m_Ptr; }
	TYPE* operator->(){ return m_Ptr; }
	TYPE*& operator=(TYPE* p){ return m_Ptr = p; }
	void SafeDelete(){ if(m_Ptr){ delete m_Ptr; m_Ptr = NULL; } }
};

/*
 *	fʒ_f[^
 */
class CProfileVertex{
	friend class CProfileFace;
	friend class CProfilePlugin;
private:
	bool m_IgnoreCant;		//	Jg
	bool m_ReadNormal;		//	@ǍtO
	bool m_ShadowDrawed;	//	e`tO
	VEC2 m_Coord;			//	W
	VEC2 m_Normal;			//	@
	VEC3 m_TransCoord[2];	//	ꎞW
	D3DCOLOR m_Diffuse;		//	_F
	float m_TexU;			//	eNX` U W
public:
	char *Read(char *, bool);
	bool IsSame(CProfileVertex *rhs){
		return m_IgnoreCant==rhs->m_IgnoreCant && m_Coord==rhs->m_Coord;
	}
};

//	q
typedef list<CProfileVertex>::iterator IProfileVertex;
typedef list<CProfileVertex *>::iterator IPProfileVertex;

/*
 *	fʕӃf[^
 */
class CProfileFace{
	friend class CProfilePlugin;
private:
	list<CProfileVertex> m_Vertex;	//	_
public:
	char *Read(char *, bool);
};

//	q
typedef list<CProfileFace>::iterator IProfileFace;

/*
 *	fʃf[^
 */
class CProfile{
	friend class CProfilePlugin;
private:
	float m_TexMapVTemp;		//	}bsOʒu
	float m_TexVPerMeter;		//	 V W
	bool m_UseTexture;			//	eNX`gptO
	string m_TexFileName;		//	eNX`t@C
	LPTEX8 m_Texture;			//	eNX`
	list<CProfileFace> m_Face;	//	f
	map<CScene *, MapPtrValue<CQuadDumpN> > m_DumpN;	//	_p (eNX`Ȃ)
	map<CScene *, MapPtrValue<CQuadDumpNX> > m_DumpNX;	//	_p (eNX`)
public:
	CProfile();
	~CProfile();
	void ClearAll();
	char *Read(char *);
	void LoadTexture();
	void PrepareDump();
};

//	q
typedef list<CProfile>::iterator IProfile;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ct[_f[^
 */
class CWireframeVertex{
	friend class CProfilePlugin;
private:
	bool m_IgnoreCant;	//	Jg
	VEC3 m_Coord;		//	W
	D3DCOLOR m_Diffuse;	//	_F
public:
	char *Read(char *);
};

//	q
typedef list<CWireframeVertex>::iterator IWireframeVertex;

/*
 *	Ct[f[^
 */
class CWireframeLine{
	friend class CProfilePlugin;
private:
	list<CWireframeVertex> m_Vertex;	//	_
public:
	char *Read(char *);
};

//	q
typedef list<CWireframeLine>::iterator IWireframeLine;

/*
 *	Ct[f[^
 */
class CWireframe{
	friend class CProfilePlugin;
private:
	float m_MinInterval;			//	ŏԊu
	float m_MaxInterval;			//	őԊu
	list<CWireframeLine> m_Line;	//	f
	map<CScene *, MapPtrValue<CLineDumpN> > m_DumpN;	//	_p
public:
	CWireframe();
	~CWireframe();
	void ClearAll();
	char *Read(char *);
	void PrepareDump();
	bool CheckInterval(float l){
		return (m_MinInterval<0.0f || m_MinInterval<=l)
			&& (m_MaxInterval<0.0f || l<m_MaxInterval);
	}
};

//	q
typedef list<CWireframe>::iterator IWireframe;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ԋuzuf[^
 */
class CInterval{
	friend class CProfilePlugin;
private:
	bool m_IgnoreCant;		//	Jg
	float m_IntervalTemp;	//	݈ʒu
	float m_Interval;		//	Ԋu
	float m_Offset;			//	ItZbg
	float m_ModelScale;		//	fXP[
	string m_ModelFileName;	//	ft@C
	CMesh *m_Mesh;			//	bV
	CObject m_Object;		//	IuWFNg
public:
	char *Read(char *);
	void LoadModel();
};

//	q
typedef list<CInterval>::iterator IInterval;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	fʃvOC
 */
class CProfilePlugin: public CPlugin{
protected:
	static vector<CProfileVertex *> ms_TempIndex;	//	ƗpCfbNXobt@
	list<CProfileVertex *> m_ProfileVertex;	//	fʒ_Xg
	list<CProfile> m_Profile;				//	f
	list<CWireframe> m_Wireframe;			//	Ct[
	list<CInterval> m_Interval;				//	Ԋuzu
public:
	CProfilePlugin(char *id): CPlugin(id){}
	virtual ~CProfilePlugin(){}
	virtual char *DirName() = 0;
	virtual char *TextName2() = 0;
	virtual bool Load() = 0;
	virtual void SetPreview() = 0;
	virtual bool UseTaper(){ return false; }
	virtual float GetTaperZ(){ return 0.0f; }
	bool HasInterval(){ return !!m_Interval.size(); }
	char *ReadProfile(char *);
	void LoadData();
	void Dump(VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &,
		VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, float, int);
	void Render(VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &,
		VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &,
		int, float, MAT8 *altmat = NULL);
	virtual void BeforeDump(VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &){}
	virtual void AfterDump(VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &){}
	void ResetMapTemp();
	void CopyMapTemp(vector<float> &);
	void AddMapTemp(float);
	void SetMapTemp(vector<float> &);
	void ClearDump();
	void ClearDumpAll();
	void PrepareVertex();
	void RenderAll();
	CPLUGIN_CASTFUNC(CProfilePlugin);
};

/*
 *	fʃvOCXg
 */
class CProfilePluginList: public CPluginList{
protected:
public:
	virtual char *DirName() = 0;
	virtual char *TextName2() = 0;
	void ClearDump();
	void ClearDumpAll();
	void PrepareVertex();
	void RenderAll();
	virtual CPlugin *NewEntry(char *) = 0;
	CPLUGINLIST_CASTFUNC(CProfilePlugin);
};

//	֐錾
char *ReadMapVector(char *, char *, vector<float> &);
void SaveMapVector(FILE *, char *, vector<float> &);

#endif
