#ifndef CPOPMENU_H_INCLUDED
#define CPOPMENU_H_INCLUDED

/*
 *	j[R}hIuWFNg
 */
class CMenuCommand{
public:
	virtual ~CMenuCommand(){}
	virtual void Exec() = 0;
};

/*
 *	|bvAbvj[
 */
class CPopMenu{
private:
	static CPopMenu *ms_ActiveMenu;	//	gp̃j[
	int m_ChildNum;				//	q
	int m_PosX, m_PosY;			//	W
	int m_Width, m_Height;		//	j[TCY
	int m_Expand;				//	WJ
	bool m_Enabled;				//	LtO
	string m_String;			//	
	CMenuCommand *m_Command;	//	R}h
	CPopMenu *m_Pointed;		//	|Cg ID
	CPopMenu *m_Parent;			//	e
	CPopMenu *m_Brother;		//	Z
	CPopMenu *m_Child;			//	q
public:
	static int ScanInputAll();
	static void RenderAll();
	static void ResetCurrentMenu(){ ms_ActiveMenu = NULL; }
	CPopMenu(char *, CPopMenu *);
	~CPopMenu();
	void SetString(char *str){ m_String = str; }
	void InsertMenu(CPopMenu *);
	bool IsExpand(){ return m_Expand>=0; }
	bool IsEnabled(){ return m_Enabled; }
	void Enable(bool en){ m_Enabled = en; }
	bool IsInside(int, int);
	int HitTest(int, int);
	CPopMenu *GetMenu(int);
	void ClearCommand(){ DELETE_V(m_Command); }
	void SetCommand(CMenuCommand *cmd){ ClearCommand(); m_Command = cmd; }
	void Popup(int, int, int tw = 0, int th = 0, int dir = 3);
	int ScanInput();
	void Render();
};

//	R}h^Cv
typedef enum{
	CMD_NONE = 0,	//	s
	CMD_PITVELEM,	//	vOCc[
	CMD_PILVELEM,	//	vOCXg
	CMD_GROUP,		//	Ґ
	CMD_TRAIN,		//	q
	CMD_SCENE,		//	V[
	CMD_GROUPTMP,	//	Ґev[g
	CMD_ROUTINE,	//	_C[`
	CMD_FILE,		//	t@C
	CMD_NETWORK,	//	lbg[N
} CMDTYPE;

/*
 *	j[R}_
 */
class CMenuCommander{
public:
	virtual CPopMenu *Dispatch(CMDTYPE, DWORD) = 0;
	virtual void DoubleClick(CMDTYPE, DWORD){}
};

#endif
