#ifndef CPLUGIN_H_INCLUDED
#define CPLUGIN_H_INCLUDED

class CSynErr;
class CTreeDirElement;
class CTreeFileElement;
class CPluginTree;

/*
 *	vOC{NX
 */
class CPlugin{
	friend class CTreeFileElement;
	friend class CPluginList;
protected:
	static bool ms_PreviewState;	//	vr[
	char *m_Buffer;			//	`XNvg (ŏ)
	char *m_Script;			//	`XNvg (wb_ȍ~)
	int m_State;			//	 (0: init, 1: preloaded, 2: loaded)
	bool m_InsertTreeFlag;	//	c[}tO
	float m_Version;		//	Ήo[W
	LPTEX8 m_IconTex;		//	ACReNX`
	float m_IconRect[4];	//	ACRʒu
	string m_ID;			//	ID
	string m_Name;			//	
	string m_Author;		//	
	string m_IconFileName;	//	
	string m_Description;	//	
	CPlugin *m_Next;		//	|C^
public:
	static bool IsPreview(){ return ms_PreviewState; }
	static void ResetPreview(){ ms_PreviewState = false; }
	CPlugin(char *);
	virtual ~CPlugin();
	virtual char *DirName() = 0;
	virtual char *TextName(){ return NULL; }
	virtual char *TextName2() = 0;
	virtual char *SaveString(){ return GetID(); }
	char *GetID(){ return (char *)m_ID.c_str(); }
	char *GetName(){ return (char *)m_Name.c_str(); }
	char *GetAuthor(){ return (char *)m_Author.c_str(); }
	bool IsInserted(){ return m_InsertTreeFlag; }
	int Compare(CPlugin *);
	bool ChDir();
	void HandleError(CSynErr *);
	char *LoadHeader(char *);
	bool PreLoad(FILE *);
	bool PreLoadOldForm(FILE *);
	virtual bool Load() = 0;
	virtual bool LoadOldForm(){ return false; }
	CPlugin *LoadAndGet();
	string GetBasicInfo();
	string GetDescription(){ return m_Description; }
	CTreeFileElement *InsertItem(CTreeDirElement *, CPluginTree *);
	virtual void SetTreeElement(CTreeFileElement *){}
	virtual bool IsRenamable(){ return false; }
	virtual bool ConfirmRename(string &){ return false; }
	virtual bool IsDeletable(){ return false; }
	void SetIconTexture();
	LPTEX8 GetIconTexture(){ return m_IconTex; }
	float *GetIconRect(){ return m_IconRect; }
	virtual void SetPreview(){}
};

#define CPLUGIN_CASTFUNC(type) \
	type *Next(){ return (type *)m_Next; }

/*
 *	vOCXg
 */
class CPluginList{
protected:
	int m_PluginNum;	//	vOC
	CPlugin *m_List;	//	Xg擪
public:
	CPluginList();
	virtual ~CPluginList();
	virtual char *DirName() = 0;
	virtual char *TextName(){ return NULL; }
	virtual char *TextName2() = 0;
	virtual char *Default(){ return NULL; }
	virtual CPlugin *NewEntry(char *) = 0;
	bool List();
	bool LoadOne(char *, char *, bool);
	CPlugin *FindPlugin(const char *, bool load = true);
	CPlugin *FindAvailable();
	void BuildTree(CPluginTree *);
};

//	LXg֐
#define CPLUGINLIST_CASTFUNC(type) \
	type *Root(){ return (type *)m_List; } \
	type *FindPlugin(const char *id, bool load = true){ \
		CPlugin *pi = CPluginList::FindPlugin(id, load); \
		return pi ? (type *)pi : NULL; \
	} \
	type *FindAvailable(){ \
		CPlugin *pi = CPluginList::FindAvailable(); \
		return pi ? (type *)pi : NULL; \
	}

/*
 *	NULL łȂ΃vOC IDANULL Ȃ󕶎Ԃ
 */
inline char *CheckPluginID(CPlugin *pi){ return (char *)(pi ? pi->GetID() : ""); }

//	֐錾
char *LoadBinaryText(FILE *, int maxbyte = -1);
char *LoadBinaryText(char *, int maxbyte = -1);

#endif
