#ifndef CPIERPLUGIN_H_INCLUDED
#define CPIERPLUGIN_H_INCLUDED

#include "CProfilePlugin.h"

/*
 *	rvOC
 */
class CPierPlugin: public CProfilePlugin{
	friend class CPier;
	friend class CLineBuildCurve;
private:
	int m_TrackNum;			//	O
	float m_TrackInterval;	//	OԊu
	float m_Interval;			//	Ԋu
	float m_Offset;				//	ItZbg
	float m_BuildMinAlt;		//	ݍŏx
	float m_TaperX, m_TaperY;	//	XY e[p
	float m_TaperZ;				//	Z e[p (Ԋuzup)
	float m_PierPos;			//	ːԐώZ
	bool m_Direction;			//	 (false: down, true: up)
	VEC3 m_JointToHeadLocal;	//	WCgEwbhzu[JW
	VEC3 m_HeadToPierLocal;		//	wbhErzu[JW
	VEC3 m_BaseToPierLocal;		//	bErzu[JW
	CMesh *m_JointMesh;			//	WCgbV
	CMesh *m_HeadMesh;			//	wbhbV
	CMesh *m_BaseMesh;			//	bbV
	string m_JointFile;			//	WCgt@C
	string m_HeadFile;			//	wbht@C
	string m_BaseFile;			//	bt@C
	float m_JointScale;			//	WCgXP[
	float m_HeadScale;			//	wbhXP[
	float m_BaseScale;			//	bXP[
	CObject m_JointObject;		//	WCgIuWFNg
	CObject m_HeadObject;		//	wbhIuWFNg
	CObject m_BaseObject;		//	bIuWFNg
public:
	static void RenderPreview();
	CPierPlugin(char *id): CProfilePlugin(id){}
	char *DirName(){ return "Pier"; }
	char *TextName2(){ return "Pier2.txt"; }
	bool IsMultiTrack(){ return m_TrackNum>1; }
	int ConfirmMultiTrack(int tn, float ti){
		return tn!=m_TrackNum ? 1 : (tn>1 && ti!=m_TrackInterval ? 2 : 0);
	}
	bool UseTaper(){ return true; }
	float GetTaperZ(){ return m_Direction ? -m_TaperZ : m_TaperZ; }
	bool Load();
	void SetPreview();
	void Preview(VEC3, float);
	float GetPierPos(){ return m_PierPos; }
	void AddPierPos(float);
	void ResetPierPos(){ m_PierPos = m_Offset; }
	void SetPierPos(float pp){ m_PierPos = pp; }
	CPLUGIN_CASTFUNC(CPierPlugin);
};

/*
 *	rvOCXg
 */
class CPierPluginList: public CProfilePluginList{
private:
public:
	char *DirName(){ return "Pier"; }
	char *TextName2(){ return "Pier2.txt"; }
	char *Default(){ return "Default_SinglePC"; }
	CPlugin *NewEntry(char *id){ return new CPierPlugin(id); }
	CPLUGINLIST_CASTFUNC(CPierPlugin);
};

//	OO[o
extern CPierPlugin *g_Pier;
extern CPierPluginList *g_PierPluginList;

#endif
