#ifndef CPARTICLE_H_INCLUDED
#define CPARTICLE_H_INCLUDED

class CNamedObject;
class CModelPlugin;
class CParticle;
class CParticleState;
class CScene;

/*
 *	p[eBNCX^X
 */
class CParticleInst{
private:
	float m_CameraDist;		//	J̋
	CParticle *m_Emitter;	//	G~b^
	VEC3 m_Pos;				//	W
	VEC3 m_Dir;				//	x
	float m_InitRadius;		//	a
	float m_FinRadius;		//	ŏIa
	float m_Alpha;			//	At@
	float m_Angle;			//	px
	D3DCOLOR m_Color;		//	F
	int m_Lifetime;			//	
	int m_Timer;			//	oߎ
	CScene *m_Scene;		//	V[
public:
	CParticleInst(CParticle *, VEC3, VEC3, float, float, int, CScene *);
	void CalcDist(){ m_CameraDist = V3Len(&(GetVPos()-m_Pos)); }
	bool operator<(const CParticleInst &rhs){ return m_CameraDist>rhs.m_CameraDist; }
	void Render();
	bool Simulate();
};

//	q
typedef list<CParticleInst>::iterator IParticleInst;

/*
 *	p[eBNG~b^
 */
class CParticleState{
	friend class CParticle;
private:
	bool m_ApplyFlag;		//	KptO
	float m_EmissionCredit;	//	oc
	float m_OldSpeed;		//	O񑬓x
	VEC3 m_OldPos;			//	OW
public:
	CParticleState(){ Reset(); }
	void Reset(){ m_EmissionCredit = -1.0f; }
	void Confirm(){ if(!m_ApplyFlag) m_EmissionCredit = -1.0f; }
	char *Read(char *);
	void Save(FILE *, char *);
};

//	q
typedef list<CParticleState>::iterator IParticleState;

/*
 *	p[eBNG~b^
 */
class CParticle{
	friend class CParticleInst;
private:
	static list<CParticleInst> ms_RenderList;	//	_OXg
	string m_TextureFileName;		//	eNX`t@C
	LPTEX8 m_Texture;				//	eNX`
	CNamedObject *m_Link;			//	ڑIuWFNg
	float m_MinQty, m_MaxQty;		//	ŏEő˗
	float m_VelocityRel;			//	xᐬ
	float m_AccelerationRel;		//	xᐬ
	float m_DecelerationRel;		//	xᐬ
	float m_EmissionQuantity[3];	//	1 b˗
	float m_Lifetime[2];			//	 [b]
	VEC3 m_SourceCoord;				//	ʒu
	VEC3 m_Direction[2];			//	
	float m_InitialRadius[2];		//	a
	float m_FinalRadius[2];			//	ŏIa
	D3DCOLOR m_Color[2];			//	F
	int m_BlendMode;				//	uh[h
	float m_AirResistance;			//	CR
	float m_Gravity;				//	d
	float m_Turbulence;				//	C
	CParticleState *m_LinkState;	//	ԕϐ
public:
	static void InitRenderList();
	static void RenderAll();
	static void SimulateAll();
	char *Read(char *, CModelPlugin *);
	void LoadData();
	void Link(CParticleState *);
	void Register(CScene *);
};

//	q
typedef list<CParticle>::iterator IParticle;

//	OO[o
extern VEC3 g_WindDir;
extern VEC3 g_WindDirNorm;

#endif
